package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.omics.model.primitives.{
  CreationTime,
  UpdateTime,
  JobStatusMsg,
  StoreName,
  CompletionTime,
  Arn,
  RunLeftNormalization,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class GetAnnotationImportJobResponse(
    completionTime: CompletionTime,
    creationTime: CreationTime,
    destinationName: StoreName,
    formatOptions: zio.aws.omics.model.FormatOptions,
    id: ResourceId,
    items: Iterable[zio.aws.omics.model.AnnotationImportItemDetail],
    roleArn: Arn,
    runLeftNormalization: RunLeftNormalization,
    status: zio.aws.omics.model.JobStatus,
    statusMessage: JobStatusMsg,
    updateTime: UpdateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse = {
    import GetAnnotationImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse
      .builder()
      .completionTime(CompletionTime.unwrap(completionTime): Instant)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .destinationName(StoreName.unwrap(destinationName): java.lang.String)
      .formatOptions(formatOptions.buildAwsValue())
      .id(ResourceId.unwrap(id): java.lang.String)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .runLeftNormalization(
        RunLeftNormalization.unwrap(runLeftNormalization): java.lang.Boolean
      )
      .status(status.unwrap)
      .statusMessage(JobStatusMsg.unwrap(statusMessage): java.lang.String)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetAnnotationImportJobResponse.ReadOnly =
    zio.aws.omics.model.GetAnnotationImportJobResponse.wrap(buildAwsValue())
}
object GetAnnotationImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetAnnotationImportJobResponse =
      zio.aws.omics.model.GetAnnotationImportJobResponse(
        completionTime,
        creationTime,
        destinationName,
        formatOptions.asEditable,
        id,
        items.map { item =>
          item.asEditable
        },
        roleArn,
        runLeftNormalization,
        status,
        statusMessage,
        updateTime
      )
    def completionTime: CompletionTime
    def creationTime: CreationTime
    def destinationName: StoreName
    def formatOptions: zio.aws.omics.model.FormatOptions.ReadOnly
    def id: ResourceId
    def items: List[zio.aws.omics.model.AnnotationImportItemDetail.ReadOnly]
    def roleArn: Arn
    def runLeftNormalization: RunLeftNormalization
    def status: zio.aws.omics.model.JobStatus
    def statusMessage: JobStatusMsg
    def updateTime: UpdateTime
    def getCompletionTime: ZIO[Any, Nothing, CompletionTime] =
      ZIO.succeed(completionTime)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getDestinationName: ZIO[Any, Nothing, StoreName] =
      ZIO.succeed(destinationName)
    def getFormatOptions
        : ZIO[Any, Nothing, zio.aws.omics.model.FormatOptions.ReadOnly] =
      ZIO.succeed(formatOptions)
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.omics.model.AnnotationImportItemDetail.ReadOnly
    ]] = ZIO.succeed(items)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getRunLeftNormalization: ZIO[Any, Nothing, RunLeftNormalization] =
      ZIO.succeed(runLeftNormalization)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.JobStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, Nothing, JobStatusMsg] =
      ZIO.succeed(statusMessage)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse
  ) extends zio.aws.omics.model.GetAnnotationImportJobResponse.ReadOnly {
    override val completionTime: CompletionTime =
      zio.aws.omics.model.primitives.CompletionTime(impl.completionTime())
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val destinationName: StoreName =
      zio.aws.omics.model.primitives.StoreName(impl.destinationName())
    override val formatOptions: zio.aws.omics.model.FormatOptions.ReadOnly =
      zio.aws.omics.model.FormatOptions.wrap(impl.formatOptions())
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val items
        : List[zio.aws.omics.model.AnnotationImportItemDetail.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.omics.model.AnnotationImportItemDetail.wrap(item)
      }
      .toList
    override val roleArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.roleArn())
    override val runLeftNormalization: RunLeftNormalization =
      zio.aws.omics.model.primitives
        .RunLeftNormalization(impl.runLeftNormalization())
    override val status: zio.aws.omics.model.JobStatus =
      zio.aws.omics.model.JobStatus.wrap(impl.status())
    override val statusMessage: JobStatusMsg =
      zio.aws.omics.model.primitives.JobStatusMsg(impl.statusMessage())
    override val updateTime: UpdateTime =
      zio.aws.omics.model.primitives.UpdateTime(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse
  ): zio.aws.omics.model.GetAnnotationImportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
