package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  JobStatusMessage,
  SequenceStoreId,
  ActivationJobId,
  SyntheticTimestamp_date_time
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetReadSetActivationJobResponse(
    completionTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time,
    id: ActivationJobId,
    sequenceStoreId: SequenceStoreId,
    sources: Optional[Iterable[zio.aws.omics.model.ActivateReadSetSourceItem]] =
      Optional.Absent,
    status: zio.aws.omics.model.ReadSetActivationJobStatus,
    statusMessage: Optional[JobStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse = {
    import GetReadSetActivationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse
      .builder()
      .optionallyWith(
        completionTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.completionTime)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .id(ActivationJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          JobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetActivationJobResponse.ReadOnly =
    zio.aws.omics.model.GetReadSetActivationJobResponse.wrap(buildAwsValue())
}
object GetReadSetActivationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetActivationJobResponse =
      zio.aws.omics.model.GetReadSetActivationJobResponse(
        completionTime.map(value => value),
        creationTime,
        id,
        sequenceStoreId,
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status,
        statusMessage.map(value => value)
      )
    def completionTime: Optional[SyntheticTimestamp_date_time]
    def creationTime: SyntheticTimestamp_date_time
    def id: ActivationJobId
    def sequenceStoreId: SequenceStoreId
    def sources
        : Optional[List[zio.aws.omics.model.ActivateReadSetSourceItem.ReadOnly]]
    def status: zio.aws.omics.model.ReadSetActivationJobStatus
    def statusMessage: Optional[JobStatusMessage]
    def getCompletionTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getId: ZIO[Any, Nothing, ActivationJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.omics.model.ActivateReadSetSourceItem.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetActivationJobStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, JobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse
  ) extends zio.aws.omics.model.GetReadSetActivationJobResponse.ReadOnly {
    override val completionTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val id: ActivationJobId =
      zio.aws.omics.model.primitives.ActivationJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val sources: Optional[
      List[zio.aws.omics.model.ActivateReadSetSourceItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.omics.model.ActivateReadSetSourceItem.wrap(item)
        }.toList
      )
    override val status: zio.aws.omics.model.ReadSetActivationJobStatus =
      zio.aws.omics.model.ReadSetActivationJobStatus.wrap(impl.status())
    override val statusMessage: Optional[JobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.JobStatusMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse
  ): zio.aws.omics.model.GetReadSetActivationJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
