package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{SequenceStoreId, ExportJobId}
import scala.jdk.CollectionConverters._
final case class GetReadSetExportJobRequest(
    id: ExportJobId,
    sequenceStoreId: SequenceStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest = {
    import GetReadSetExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest
      .builder()
      .id(ExportJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetExportJobRequest.ReadOnly =
    zio.aws.omics.model.GetReadSetExportJobRequest.wrap(buildAwsValue())
}
object GetReadSetExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetExportJobRequest =
      zio.aws.omics.model.GetReadSetExportJobRequest(id, sequenceStoreId)
    def id: ExportJobId
    def sequenceStoreId: SequenceStoreId
    def getId: ZIO[Any, Nothing, ExportJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest
  ) extends zio.aws.omics.model.GetReadSetExportJobRequest.ReadOnly {
    override val id: ExportJobId =
      zio.aws.omics.model.primitives.ExportJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest
  ): zio.aws.omics.model.GetReadSetExportJobRequest.ReadOnly = new Wrapper(impl)
}
