package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ExportJobId,
  SequenceStoreId,
  SyntheticTimestamp_date_time,
  JobStatusMessage,
  S3Destination
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetReadSetExportJobResponse(
    completionTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time,
    destination: S3Destination,
    id: ExportJobId,
    readSets: Optional[Iterable[zio.aws.omics.model.ExportReadSetDetail]] =
      Optional.Absent,
    sequenceStoreId: SequenceStoreId,
    status: zio.aws.omics.model.ReadSetExportJobStatus,
    statusMessage: Optional[JobStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse = {
    import GetReadSetExportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse
      .builder()
      .optionallyWith(
        completionTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.completionTime)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .destination(S3Destination.unwrap(destination): java.lang.String)
      .id(ExportJobId.unwrap(id): java.lang.String)
      .optionallyWith(
        readSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.readSets)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          JobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetExportJobResponse.ReadOnly =
    zio.aws.omics.model.GetReadSetExportJobResponse.wrap(buildAwsValue())
}
object GetReadSetExportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetExportJobResponse =
      zio.aws.omics.model.GetReadSetExportJobResponse(
        completionTime.map(value => value),
        creationTime,
        destination,
        id,
        readSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sequenceStoreId,
        status,
        statusMessage.map(value => value)
      )
    def completionTime: Optional[SyntheticTimestamp_date_time]
    def creationTime: SyntheticTimestamp_date_time
    def destination: S3Destination
    def id: ExportJobId
    def readSets
        : Optional[List[zio.aws.omics.model.ExportReadSetDetail.ReadOnly]]
    def sequenceStoreId: SequenceStoreId
    def status: zio.aws.omics.model.ReadSetExportJobStatus
    def statusMessage: Optional[JobStatusMessage]
    def getCompletionTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getDestination: ZIO[Any, Nothing, S3Destination] =
      ZIO.succeed(destination)
    def getId: ZIO[Any, Nothing, ExportJobId] = ZIO.succeed(id)
    def getReadSets: ZIO[Any, AwsError, List[
      zio.aws.omics.model.ExportReadSetDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("readSets", readSets)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetExportJobStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, JobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse
  ) extends zio.aws.omics.model.GetReadSetExportJobResponse.ReadOnly {
    override val completionTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val destination: S3Destination =
      zio.aws.omics.model.primitives.S3Destination(impl.destination())
    override val id: ExportJobId =
      zio.aws.omics.model.primitives.ExportJobId(impl.id())
    override val readSets
        : Optional[List[zio.aws.omics.model.ExportReadSetDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.ExportReadSetDetail.wrap(item)
          }.toList
        )
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val status: zio.aws.omics.model.ReadSetExportJobStatus =
      zio.aws.omics.model.ReadSetExportJobStatus.wrap(impl.status())
    override val statusMessage: Optional[JobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.JobStatusMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse
  ): zio.aws.omics.model.GetReadSetExportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
