package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  RoleArn,
  SequenceStoreId,
  SyntheticTimestamp_date_time,
  JobStatusMessage,
  ImportJobId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetReadSetImportJobResponse(
    completionTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time,
    id: ImportJobId,
    roleArn: RoleArn,
    sequenceStoreId: SequenceStoreId,
    sources: Iterable[zio.aws.omics.model.ImportReadSetSourceItem],
    status: zio.aws.omics.model.ReadSetImportJobStatus,
    statusMessage: Optional[JobStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse = {
    import GetReadSetImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse
      .builder()
      .optionallyWith(
        completionTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.completionTime)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .id(ImportJobId.unwrap(id): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          JobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetImportJobResponse.ReadOnly =
    zio.aws.omics.model.GetReadSetImportJobResponse.wrap(buildAwsValue())
}
object GetReadSetImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetImportJobResponse =
      zio.aws.omics.model.GetReadSetImportJobResponse(
        completionTime.map(value => value),
        creationTime,
        id,
        roleArn,
        sequenceStoreId,
        sources.map { item =>
          item.asEditable
        },
        status,
        statusMessage.map(value => value)
      )
    def completionTime: Optional[SyntheticTimestamp_date_time]
    def creationTime: SyntheticTimestamp_date_time
    def id: ImportJobId
    def roleArn: RoleArn
    def sequenceStoreId: SequenceStoreId
    def sources: List[zio.aws.omics.model.ImportReadSetSourceItem.ReadOnly]
    def status: zio.aws.omics.model.ReadSetImportJobStatus
    def statusMessage: Optional[JobStatusMessage]
    def getCompletionTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getId: ZIO[Any, Nothing, ImportJobId] = ZIO.succeed(id)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.omics.model.ImportReadSetSourceItem.ReadOnly
    ]] = ZIO.succeed(sources)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetImportJobStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, JobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse
  ) extends zio.aws.omics.model.GetReadSetImportJobResponse.ReadOnly {
    override val completionTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val id: ImportJobId =
      zio.aws.omics.model.primitives.ImportJobId(impl.id())
    override val roleArn: RoleArn =
      zio.aws.omics.model.primitives.RoleArn(impl.roleArn())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val sources
        : List[zio.aws.omics.model.ImportReadSetSourceItem.ReadOnly] = impl
      .sources()
      .asScala
      .map { item =>
        zio.aws.omics.model.ImportReadSetSourceItem.wrap(item)
      }
      .toList
    override val status: zio.aws.omics.model.ReadSetImportJobStatus =
      zio.aws.omics.model.ReadSetImportJobStatus.wrap(impl.status())
    override val statusMessage: Optional[JobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.JobStatusMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse
  ): zio.aws.omics.model.GetReadSetImportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
