package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ReadSetName,
  SubjectId,
  SampleId,
  SequenceStoreId,
  SyntheticTimestamp_date_time,
  ReadSetDescription,
  ReadSetId,
  ReferenceArn,
  ReadSetArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetReadSetMetadataResponse(
    arn: ReadSetArn,
    creationTime: SyntheticTimestamp_date_time,
    description: Optional[ReadSetDescription] = Optional.Absent,
    fileType: zio.aws.omics.model.FileType,
    files: Optional[zio.aws.omics.model.ReadSetFiles] = Optional.Absent,
    id: ReadSetId,
    name: Optional[ReadSetName] = Optional.Absent,
    referenceArn: Optional[ReferenceArn] = Optional.Absent,
    sampleId: Optional[SampleId] = Optional.Absent,
    sequenceInformation: Optional[zio.aws.omics.model.SequenceInformation] =
      Optional.Absent,
    sequenceStoreId: SequenceStoreId,
    status: zio.aws.omics.model.ReadSetStatus,
    subjectId: Optional[SubjectId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse = {
    import GetReadSetMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse
      .builder()
      .arn(ReadSetArn.unwrap(arn): java.lang.String)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .optionallyWith(
        description.map(value =>
          ReadSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .fileType(fileType.unwrap)
      .optionallyWith(files.map(value => value.buildAwsValue()))(_.files)
      .id(ReadSetId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => ReadSetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        referenceArn.map(value => ReferenceArn.unwrap(value): java.lang.String)
      )(_.referenceArn)
      .optionallyWith(
        sampleId.map(value => SampleId.unwrap(value): java.lang.String)
      )(_.sampleId)
      .optionallyWith(sequenceInformation.map(value => value.buildAwsValue()))(
        _.sequenceInformation
      )
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(
        subjectId.map(value => SubjectId.unwrap(value): java.lang.String)
      )(_.subjectId)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetMetadataResponse.ReadOnly =
    zio.aws.omics.model.GetReadSetMetadataResponse.wrap(buildAwsValue())
}
object GetReadSetMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetMetadataResponse =
      zio.aws.omics.model.GetReadSetMetadataResponse(
        arn,
        creationTime,
        description.map(value => value),
        fileType,
        files.map(value => value.asEditable),
        id,
        name.map(value => value),
        referenceArn.map(value => value),
        sampleId.map(value => value),
        sequenceInformation.map(value => value.asEditable),
        sequenceStoreId,
        status,
        subjectId.map(value => value)
      )
    def arn: ReadSetArn
    def creationTime: SyntheticTimestamp_date_time
    def description: Optional[ReadSetDescription]
    def fileType: zio.aws.omics.model.FileType
    def files: Optional[zio.aws.omics.model.ReadSetFiles.ReadOnly]
    def id: ReadSetId
    def name: Optional[ReadSetName]
    def referenceArn: Optional[ReferenceArn]
    def sampleId: Optional[SampleId]
    def sequenceInformation
        : Optional[zio.aws.omics.model.SequenceInformation.ReadOnly]
    def sequenceStoreId: SequenceStoreId
    def status: zio.aws.omics.model.ReadSetStatus
    def subjectId: Optional[SubjectId]
    def getArn: ZIO[Any, Nothing, ReadSetArn] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getDescription: ZIO[Any, AwsError, ReadSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFileType: ZIO[Any, Nothing, zio.aws.omics.model.FileType] =
      ZIO.succeed(fileType)
    def getFiles
        : ZIO[Any, AwsError, zio.aws.omics.model.ReadSetFiles.ReadOnly] =
      AwsError.unwrapOptionField("files", files)
    def getId: ZIO[Any, Nothing, ReadSetId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, ReadSetName] =
      AwsError.unwrapOptionField("name", name)
    def getReferenceArn: ZIO[Any, AwsError, ReferenceArn] =
      AwsError.unwrapOptionField("referenceArn", referenceArn)
    def getSampleId: ZIO[Any, AwsError, SampleId] =
      AwsError.unwrapOptionField("sampleId", sampleId)
    def getSequenceInformation
        : ZIO[Any, AwsError, zio.aws.omics.model.SequenceInformation.ReadOnly] =
      AwsError.unwrapOptionField("sequenceInformation", sequenceInformation)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.ReadSetStatus] =
      ZIO.succeed(status)
    def getSubjectId: ZIO[Any, AwsError, SubjectId] =
      AwsError.unwrapOptionField("subjectId", subjectId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse
  ) extends zio.aws.omics.model.GetReadSetMetadataResponse.ReadOnly {
    override val arn: ReadSetArn =
      zio.aws.omics.model.primitives.ReadSetArn(impl.arn())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val description: Optional[ReadSetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.omics.model.primitives.ReadSetDescription(value))
    override val fileType: zio.aws.omics.model.FileType =
      zio.aws.omics.model.FileType.wrap(impl.fileType())
    override val files: Optional[zio.aws.omics.model.ReadSetFiles.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.files())
        .map(value => zio.aws.omics.model.ReadSetFiles.wrap(value))
    override val id: ReadSetId =
      zio.aws.omics.model.primitives.ReadSetId(impl.id())
    override val name: Optional[ReadSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReadSetName(value))
    override val referenceArn: Optional[ReferenceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceArn())
      .map(value => zio.aws.omics.model.primitives.ReferenceArn(value))
    override val sampleId: Optional[SampleId] = zio.aws.core.internal
      .optionalFromNullable(impl.sampleId())
      .map(value => zio.aws.omics.model.primitives.SampleId(value))
    override val sequenceInformation
        : Optional[zio.aws.omics.model.SequenceInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sequenceInformation())
        .map(value => zio.aws.omics.model.SequenceInformation.wrap(value))
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val status: zio.aws.omics.model.ReadSetStatus =
      zio.aws.omics.model.ReadSetStatus.wrap(impl.status())
    override val subjectId: Optional[SubjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.subjectId())
      .map(value => zio.aws.omics.model.primitives.SubjectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse
  ): zio.aws.omics.model.GetReadSetMetadataResponse.ReadOnly = new Wrapper(impl)
}
