package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SequenceStoreId,
  GetReadSetRequestPartNumberInteger,
  ReadSetId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetReadSetRequest(
    file: Optional[zio.aws.omics.model.ReadSetFile] = Optional.Absent,
    id: ReadSetId,
    partNumber: GetReadSetRequestPartNumberInteger,
    sequenceStoreId: SequenceStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetRequest = {
    import GetReadSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetRequest
      .builder()
      .optionallyWith(file.map(value => value.unwrap))(_.file)
      .id(ReadSetId.unwrap(id): java.lang.String)
      .partNumber(
        GetReadSetRequestPartNumberInteger.unwrap(partNumber): Integer
      )
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetRequest.ReadOnly =
    zio.aws.omics.model.GetReadSetRequest.wrap(buildAwsValue())
}
object GetReadSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetRequest =
      zio.aws.omics.model.GetReadSetRequest(
        file.map(value => value),
        id,
        partNumber,
        sequenceStoreId
      )
    def file: Optional[zio.aws.omics.model.ReadSetFile]
    def id: ReadSetId
    def partNumber: GetReadSetRequestPartNumberInteger
    def sequenceStoreId: SequenceStoreId
    def getFile: ZIO[Any, AwsError, zio.aws.omics.model.ReadSetFile] =
      AwsError.unwrapOptionField("file", file)
    def getId: ZIO[Any, Nothing, ReadSetId] = ZIO.succeed(id)
    def getPartNumber: ZIO[Any, Nothing, GetReadSetRequestPartNumberInteger] =
      ZIO.succeed(partNumber)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetRequest
  ) extends zio.aws.omics.model.GetReadSetRequest.ReadOnly {
    override val file: Optional[zio.aws.omics.model.ReadSetFile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.file())
        .map(value => zio.aws.omics.model.ReadSetFile.wrap(value))
    override val id: ReadSetId =
      zio.aws.omics.model.primitives.ReadSetId(impl.id())
    override val partNumber: GetReadSetRequestPartNumberInteger =
      zio.aws.omics.model.primitives
        .GetReadSetRequestPartNumberInteger(impl.partNumber())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetRequest
  ): zio.aws.omics.model.GetReadSetRequest.ReadOnly = new Wrapper(impl)
}
