package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SyntheticTimestamp_date_time,
  ReferenceId,
  ReferenceName,
  Md5,
  ReferenceArn,
  ReferenceDescription,
  ReferenceStoreId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetReferenceMetadataResponse(
    arn: ReferenceArn,
    creationTime: SyntheticTimestamp_date_time,
    description: Optional[ReferenceDescription] = Optional.Absent,
    files: Optional[zio.aws.omics.model.ReferenceFiles] = Optional.Absent,
    id: ReferenceId,
    md5: Md5,
    name: Optional[ReferenceName] = Optional.Absent,
    referenceStoreId: ReferenceStoreId,
    status: Optional[zio.aws.omics.model.ReferenceStatus] = Optional.Absent,
    updateTime: SyntheticTimestamp_date_time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse = {
    import GetReferenceMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse
      .builder()
      .arn(ReferenceArn.unwrap(arn): java.lang.String)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .optionallyWith(
        description.map(value =>
          ReferenceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(files.map(value => value.buildAwsValue()))(_.files)
      .id(ReferenceId.unwrap(id): java.lang.String)
      .md5(Md5.unwrap(md5): java.lang.String)
      .optionallyWith(
        name.map(value => ReferenceName.unwrap(value): java.lang.String)
      )(_.name)
      .referenceStoreId(
        ReferenceStoreId.unwrap(referenceStoreId): java.lang.String
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .updateTime(SyntheticTimestamp_date_time.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReferenceMetadataResponse.ReadOnly =
    zio.aws.omics.model.GetReferenceMetadataResponse.wrap(buildAwsValue())
}
object GetReferenceMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReferenceMetadataResponse =
      zio.aws.omics.model.GetReferenceMetadataResponse(
        arn,
        creationTime,
        description.map(value => value),
        files.map(value => value.asEditable),
        id,
        md5,
        name.map(value => value),
        referenceStoreId,
        status.map(value => value),
        updateTime
      )
    def arn: ReferenceArn
    def creationTime: SyntheticTimestamp_date_time
    def description: Optional[ReferenceDescription]
    def files: Optional[zio.aws.omics.model.ReferenceFiles.ReadOnly]
    def id: ReferenceId
    def md5: Md5
    def name: Optional[ReferenceName]
    def referenceStoreId: ReferenceStoreId
    def status: Optional[zio.aws.omics.model.ReferenceStatus]
    def updateTime: SyntheticTimestamp_date_time
    def getArn: ZIO[Any, Nothing, ReferenceArn] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getDescription: ZIO[Any, AwsError, ReferenceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFiles
        : ZIO[Any, AwsError, zio.aws.omics.model.ReferenceFiles.ReadOnly] =
      AwsError.unwrapOptionField("files", files)
    def getId: ZIO[Any, Nothing, ReferenceId] = ZIO.succeed(id)
    def getMd5: ZIO[Any, Nothing, Md5] = ZIO.succeed(md5)
    def getName: ZIO[Any, AwsError, ReferenceName] =
      AwsError.unwrapOptionField("name", name)
    def getReferenceStoreId: ZIO[Any, Nothing, ReferenceStoreId] =
      ZIO.succeed(referenceStoreId)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.ReferenceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUpdateTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse
  ) extends zio.aws.omics.model.GetReferenceMetadataResponse.ReadOnly {
    override val arn: ReferenceArn =
      zio.aws.omics.model.primitives.ReferenceArn(impl.arn())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val description: Optional[ReferenceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.omics.model.primitives.ReferenceDescription(value)
        )
    override val files: Optional[zio.aws.omics.model.ReferenceFiles.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.files())
        .map(value => zio.aws.omics.model.ReferenceFiles.wrap(value))
    override val id: ReferenceId =
      zio.aws.omics.model.primitives.ReferenceId(impl.id())
    override val md5: Md5 = zio.aws.omics.model.primitives.Md5(impl.md5())
    override val name: Optional[ReferenceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReferenceName(value))
    override val referenceStoreId: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.referenceStoreId())
    override val status: Optional[zio.aws.omics.model.ReferenceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.ReferenceStatus.wrap(value))
    override val updateTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse
  ): zio.aws.omics.model.GetReferenceMetadataResponse.ReadOnly = new Wrapper(
    impl
  )
}
