package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.ReferenceStoreId
import scala.jdk.CollectionConverters._
final case class GetReferenceStoreRequest(id: ReferenceStoreId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest = {
    import GetReferenceStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest
      .builder()
      .id(ReferenceStoreId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReferenceStoreRequest.ReadOnly =
    zio.aws.omics.model.GetReferenceStoreRequest.wrap(buildAwsValue())
}
object GetReferenceStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReferenceStoreRequest =
      zio.aws.omics.model.GetReferenceStoreRequest(id)
    def id: ReferenceStoreId
    def getId: ZIO[Any, Nothing, ReferenceStoreId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest
  ) extends zio.aws.omics.model.GetReferenceStoreRequest.ReadOnly {
    override val id: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest
  ): zio.aws.omics.model.GetReferenceStoreRequest.ReadOnly = new Wrapper(impl)
}
