package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ReferenceStoreArn,
  ReferenceStoreName,
  SyntheticTimestamp_date_time,
  ReferenceStoreDescription,
  ReferenceStoreId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetReferenceStoreResponse(
    arn: ReferenceStoreArn,
    creationTime: SyntheticTimestamp_date_time,
    description: Optional[ReferenceStoreDescription] = Optional.Absent,
    id: ReferenceStoreId,
    name: Optional[ReferenceStoreName] = Optional.Absent,
    sseConfig: Optional[zio.aws.omics.model.SseConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReferenceStoreResponse = {
    import GetReferenceStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReferenceStoreResponse
      .builder()
      .arn(ReferenceStoreArn.unwrap(arn): java.lang.String)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .optionallyWith(
        description.map(value =>
          ReferenceStoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .id(ReferenceStoreId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => ReferenceStoreName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(sseConfig.map(value => value.buildAwsValue()))(
        _.sseConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReferenceStoreResponse.ReadOnly =
    zio.aws.omics.model.GetReferenceStoreResponse.wrap(buildAwsValue())
}
object GetReferenceStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReferenceStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReferenceStoreResponse =
      zio.aws.omics.model.GetReferenceStoreResponse(
        arn,
        creationTime,
        description.map(value => value),
        id,
        name.map(value => value),
        sseConfig.map(value => value.asEditable)
      )
    def arn: ReferenceStoreArn
    def creationTime: SyntheticTimestamp_date_time
    def description: Optional[ReferenceStoreDescription]
    def id: ReferenceStoreId
    def name: Optional[ReferenceStoreName]
    def sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly]
    def getArn: ZIO[Any, Nothing, ReferenceStoreArn] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getDescription: ZIO[Any, AwsError, ReferenceStoreDescription] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, Nothing, ReferenceStoreId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, ReferenceStoreName] =
      AwsError.unwrapOptionField("name", name)
    def getSseConfig
        : ZIO[Any, AwsError, zio.aws.omics.model.SseConfig.ReadOnly] =
      AwsError.unwrapOptionField("sseConfig", sseConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceStoreResponse
  ) extends zio.aws.omics.model.GetReferenceStoreResponse.ReadOnly {
    override val arn: ReferenceStoreArn =
      zio.aws.omics.model.primitives.ReferenceStoreArn(impl.arn())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val description: Optional[ReferenceStoreDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.omics.model.primitives.ReferenceStoreDescription(value)
        )
    override val id: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.id())
    override val name: Optional[ReferenceStoreName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReferenceStoreName(value))
    override val sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseConfig())
        .map(value => zio.aws.omics.model.SseConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceStoreResponse
  ): zio.aws.omics.model.GetReferenceStoreResponse.ReadOnly = new Wrapper(impl)
}
