package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.RunGroupId
import scala.jdk.CollectionConverters._
final case class GetRunGroupRequest(id: RunGroupId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetRunGroupRequest = {
    import GetRunGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetRunGroupRequest
      .builder()
      .id(RunGroupId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetRunGroupRequest.ReadOnly =
    zio.aws.omics.model.GetRunGroupRequest.wrap(buildAwsValue())
}
object GetRunGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetRunGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetRunGroupRequest =
      zio.aws.omics.model.GetRunGroupRequest(id)
    def id: RunGroupId
    def getId: ZIO[Any, Nothing, RunGroupId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetRunGroupRequest
  ) extends zio.aws.omics.model.GetRunGroupRequest.ReadOnly {
    override val id: RunGroupId =
      zio.aws.omics.model.primitives.RunGroupId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetRunGroupRequest
  ): zio.aws.omics.model.GetRunGroupRequest.ReadOnly = new Wrapper(impl)
}
