package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.RunId
import scala.jdk.CollectionConverters._
final case class GetRunRequest(
    export: Optional[Iterable[zio.aws.omics.model.RunExport]] = Optional.Absent,
    id: RunId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetRunRequest = {
    import GetRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetRunRequest
      .builder()
      .optionallyWith(
        export.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.exportWithStrings)
      .id(RunId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetRunRequest.ReadOnly =
    zio.aws.omics.model.GetRunRequest.wrap(buildAwsValue())
}
object GetRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetRunRequest =
      zio.aws.omics.model.GetRunRequest(export.map(value => value), id)
    def export: Optional[List[zio.aws.omics.model.RunExport]]
    def id: RunId
    def getExport: ZIO[Any, AwsError, List[zio.aws.omics.model.RunExport]] =
      AwsError.unwrapOptionField("export", export)
    def getId: ZIO[Any, Nothing, RunId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetRunRequest
  ) extends zio.aws.omics.model.GetRunRequest.ReadOnly {
    override val export: Optional[List[zio.aws.omics.model.RunExport]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.export())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.RunExport.wrap(item)
          }.toList
        )
    override val id: RunId = zio.aws.omics.model.primitives.RunId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetRunRequest
  ): zio.aws.omics.model.GetRunRequest.ReadOnly = new Wrapper(impl)
}
