package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  GetRunResponsePriorityInteger,
  RunArn,
  WorkflowDefinition,
  RunRoleArn,
  RunTimestamp,
  RunOutputUri,
  TagValue,
  RunResourceDigest,
  RunStartedBy,
  RunName,
  RunResourceDigestKey,
  RunGroupId,
  WorkflowId,
  RunStatusMessage,
  GetRunResponseStorageCapacityInteger,
  TagKey,
  WorkflowDigest,
  RunId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import software.amazon.awssdk.core.document.Document
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetRunResponse(
    arn: Optional[RunArn] = Optional.Absent,
    creationTime: Optional[RunTimestamp] = Optional.Absent,
    definition: Optional[WorkflowDefinition] = Optional.Absent,
    digest: Optional[WorkflowDigest] = Optional.Absent,
    id: Optional[RunId] = Optional.Absent,
    logLevel: Optional[zio.aws.omics.model.RunLogLevel] = Optional.Absent,
    name: Optional[RunName] = Optional.Absent,
    outputUri: Optional[RunOutputUri] = Optional.Absent,
    parameters: Optional[zio.aws.omics.model.RunParameters] = Optional.Absent,
    priority: Optional[GetRunResponsePriorityInteger] = Optional.Absent,
    resourceDigests: Optional[Map[RunResourceDigestKey, RunResourceDigest]] =
      Optional.Absent,
    roleArn: Optional[RunRoleArn] = Optional.Absent,
    runGroupId: Optional[RunGroupId] = Optional.Absent,
    runId: Optional[RunId] = Optional.Absent,
    startTime: Optional[RunTimestamp] = Optional.Absent,
    startedBy: Optional[RunStartedBy] = Optional.Absent,
    status: Optional[zio.aws.omics.model.RunStatus] = Optional.Absent,
    statusMessage: Optional[RunStatusMessage] = Optional.Absent,
    stopTime: Optional[RunTimestamp] = Optional.Absent,
    storageCapacity: Optional[GetRunResponseStorageCapacityInteger] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    workflowId: Optional[WorkflowId] = Optional.Absent,
    workflowType: Optional[zio.aws.omics.model.WorkflowType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetRunResponse = {
    import GetRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetRunResponse
      .builder()
      .optionallyWith(arn.map(value => RunArn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        creationTime.map(value => RunTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        definition.map(value =>
          WorkflowDefinition.unwrap(value): java.lang.String
        )
      )(_.definition)
      .optionallyWith(
        digest.map(value => WorkflowDigest.unwrap(value): java.lang.String)
      )(_.digest)
      .optionallyWith(id.map(value => RunId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .optionallyWith(
        name.map(value => RunName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        outputUri.map(value => RunOutputUri.unwrap(value): java.lang.String)
      )(_.outputUri)
      .optionallyWith(parameters.map(value => value))(_.parameters)
      .optionallyWith(
        priority.map(value =>
          GetRunResponsePriorityInteger.unwrap(value): Integer
        )
      )(_.priority)
      .optionallyWith(
        resourceDigests.map(value =>
          value
            .map({ case (key, value) =>
              (RunResourceDigestKey.unwrap(
                key
              ): java.lang.String) -> (RunResourceDigest.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.resourceDigests)
      .optionallyWith(
        roleArn.map(value => RunRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        runGroupId.map(value => RunGroupId.unwrap(value): java.lang.String)
      )(_.runGroupId)
      .optionallyWith(
        runId.map(value => RunId.unwrap(value): java.lang.String)
      )(_.runId)
      .optionallyWith(
        startTime.map(value => RunTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        startedBy.map(value => RunStartedBy.unwrap(value): java.lang.String)
      )(_.startedBy)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          RunStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        stopTime.map(value => RunTimestamp.unwrap(value): Instant)
      )(_.stopTime)
      .optionallyWith(
        storageCapacity.map(value =>
          GetRunResponseStorageCapacityInteger.unwrap(value): Integer
        )
      )(_.storageCapacity)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        workflowId.map(value => WorkflowId.unwrap(value): java.lang.String)
      )(_.workflowId)
      .optionallyWith(workflowType.map(value => value.unwrap))(_.workflowType)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetRunResponse.ReadOnly =
    zio.aws.omics.model.GetRunResponse.wrap(buildAwsValue())
}
object GetRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetRunResponse =
      zio.aws.omics.model.GetRunResponse(
        arn.map(value => value),
        creationTime.map(value => value),
        definition.map(value => value),
        digest.map(value => value),
        id.map(value => value),
        logLevel.map(value => value),
        name.map(value => value),
        outputUri.map(value => value),
        parameters.map(value => value),
        priority.map(value => value),
        resourceDigests.map(value => value),
        roleArn.map(value => value),
        runGroupId.map(value => value),
        runId.map(value => value),
        startTime.map(value => value),
        startedBy.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        stopTime.map(value => value),
        storageCapacity.map(value => value),
        tags.map(value => value),
        workflowId.map(value => value),
        workflowType.map(value => value)
      )
    def arn: Optional[RunArn]
    def creationTime: Optional[RunTimestamp]
    def definition: Optional[WorkflowDefinition]
    def digest: Optional[WorkflowDigest]
    def id: Optional[RunId]
    def logLevel: Optional[zio.aws.omics.model.RunLogLevel]
    def name: Optional[RunName]
    def outputUri: Optional[RunOutputUri]
    def parameters: Optional[Document]
    def priority: Optional[GetRunResponsePriorityInteger]
    def resourceDigests: Optional[Map[RunResourceDigestKey, RunResourceDigest]]
    def roleArn: Optional[RunRoleArn]
    def runGroupId: Optional[RunGroupId]
    def runId: Optional[RunId]
    def startTime: Optional[RunTimestamp]
    def startedBy: Optional[RunStartedBy]
    def status: Optional[zio.aws.omics.model.RunStatus]
    def statusMessage: Optional[RunStatusMessage]
    def stopTime: Optional[RunTimestamp]
    def storageCapacity: Optional[GetRunResponseStorageCapacityInteger]
    def tags: Optional[Map[TagKey, TagValue]]
    def workflowId: Optional[WorkflowId]
    def workflowType: Optional[zio.aws.omics.model.WorkflowType]
    def getArn: ZIO[Any, AwsError, RunArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, RunTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDefinition: ZIO[Any, AwsError, WorkflowDefinition] =
      AwsError.unwrapOptionField("definition", definition)
    def getDigest: ZIO[Any, AwsError, WorkflowDigest] =
      AwsError.unwrapOptionField("digest", digest)
    def getId: ZIO[Any, AwsError, RunId] = AwsError.unwrapOptionField("id", id)
    def getLogLevel: ZIO[Any, AwsError, zio.aws.omics.model.RunLogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
    def getName: ZIO[Any, AwsError, RunName] =
      AwsError.unwrapOptionField("name", name)
    def getOutputUri: ZIO[Any, AwsError, RunOutputUri] =
      AwsError.unwrapOptionField("outputUri", outputUri)
    def getParameters: ZIO[Any, AwsError, Document] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getPriority: ZIO[Any, AwsError, GetRunResponsePriorityInteger] =
      AwsError.unwrapOptionField("priority", priority)
    def getResourceDigests
        : ZIO[Any, AwsError, Map[RunResourceDigestKey, RunResourceDigest]] =
      AwsError.unwrapOptionField("resourceDigests", resourceDigests)
    def getRoleArn: ZIO[Any, AwsError, RunRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getRunGroupId: ZIO[Any, AwsError, RunGroupId] =
      AwsError.unwrapOptionField("runGroupId", runGroupId)
    def getRunId: ZIO[Any, AwsError, RunId] =
      AwsError.unwrapOptionField("runId", runId)
    def getStartTime: ZIO[Any, AwsError, RunTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStartedBy: ZIO[Any, AwsError, RunStartedBy] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.RunStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, RunStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStopTime: ZIO[Any, AwsError, RunTimestamp] =
      AwsError.unwrapOptionField("stopTime", stopTime)
    def getStorageCapacity
        : ZIO[Any, AwsError, GetRunResponseStorageCapacityInteger] =
      AwsError.unwrapOptionField("storageCapacity", storageCapacity)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkflowId: ZIO[Any, AwsError, WorkflowId] =
      AwsError.unwrapOptionField("workflowId", workflowId)
    def getWorkflowType: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowType] =
      AwsError.unwrapOptionField("workflowType", workflowType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetRunResponse
  ) extends zio.aws.omics.model.GetRunResponse.ReadOnly {
    override val arn: Optional[RunArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.omics.model.primitives.RunArn(value))
    override val creationTime: Optional[RunTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.omics.model.primitives.RunTimestamp(value))
    override val definition: Optional[WorkflowDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definition())
        .map(value => zio.aws.omics.model.primitives.WorkflowDefinition(value))
    override val digest: Optional[WorkflowDigest] = zio.aws.core.internal
      .optionalFromNullable(impl.digest())
      .map(value => zio.aws.omics.model.primitives.WorkflowDigest(value))
    override val id: Optional[RunId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.omics.model.primitives.RunId(value))
    override val logLevel: Optional[zio.aws.omics.model.RunLogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logLevel())
        .map(value => zio.aws.omics.model.RunLogLevel.wrap(value))
    override val name: Optional[RunName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.RunName(value))
    override val outputUri: Optional[RunOutputUri] = zio.aws.core.internal
      .optionalFromNullable(impl.outputUri())
      .map(value => zio.aws.omics.model.primitives.RunOutputUri(value))
    override val parameters: Optional[Document] =
      zio.aws.core.internal.optionalFromNullable(impl.parameters())
    override val priority: Optional[GetRunResponsePriorityInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priority())
        .map(value =>
          zio.aws.omics.model.primitives.GetRunResponsePriorityInteger(value)
        )
    override val resourceDigests
        : Optional[Map[RunResourceDigestKey, RunResourceDigest]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceDigests())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.omics.model.primitives.RunResourceDigestKey(
                key
              ) -> zio.aws.omics.model.primitives.RunResourceDigest(value)
            })
            .toMap
        )
    override val roleArn: Optional[RunRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.omics.model.primitives.RunRoleArn(value))
    override val runGroupId: Optional[RunGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.runGroupId())
      .map(value => zio.aws.omics.model.primitives.RunGroupId(value))
    override val runId: Optional[RunId] = zio.aws.core.internal
      .optionalFromNullable(impl.runId())
      .map(value => zio.aws.omics.model.primitives.RunId(value))
    override val startTime: Optional[RunTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.omics.model.primitives.RunTimestamp(value))
    override val startedBy: Optional[RunStartedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.startedBy())
      .map(value => zio.aws.omics.model.primitives.RunStartedBy(value))
    override val status: Optional[zio.aws.omics.model.RunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.RunStatus.wrap(value))
    override val statusMessage: Optional[RunStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.RunStatusMessage(value))
    override val stopTime: Optional[RunTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopTime())
      .map(value => zio.aws.omics.model.primitives.RunTimestamp(value))
    override val storageCapacity
        : Optional[GetRunResponseStorageCapacityInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.storageCapacity())
      .map(value =>
        zio.aws.omics.model.primitives
          .GetRunResponseStorageCapacityInteger(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workflowId: Optional[WorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowId())
      .map(value => zio.aws.omics.model.primitives.WorkflowId(value))
    override val workflowType: Optional[zio.aws.omics.model.WorkflowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowType())
        .map(value => zio.aws.omics.model.WorkflowType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetRunResponse
  ): zio.aws.omics.model.GetRunResponse.ReadOnly = new Wrapper(impl)
}
