package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{TaskId, RunId}
import scala.jdk.CollectionConverters._
final case class GetRunTaskRequest(id: RunId, taskId: TaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetRunTaskRequest = {
    import GetRunTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetRunTaskRequest
      .builder()
      .id(RunId.unwrap(id): java.lang.String)
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetRunTaskRequest.ReadOnly =
    zio.aws.omics.model.GetRunTaskRequest.wrap(buildAwsValue())
}
object GetRunTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetRunTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetRunTaskRequest =
      zio.aws.omics.model.GetRunTaskRequest(id, taskId)
    def id: RunId
    def taskId: TaskId
    def getId: ZIO[Any, Nothing, RunId] = ZIO.succeed(id)
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetRunTaskRequest
  ) extends zio.aws.omics.model.GetRunTaskRequest.ReadOnly {
    override val id: RunId = zio.aws.omics.model.primitives.RunId(impl.id())
    override val taskId: TaskId =
      zio.aws.omics.model.primitives.TaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetRunTaskRequest
  ): zio.aws.omics.model.GetRunTaskRequest.ReadOnly = new Wrapper(impl)
}
