package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  TaskLogStream,
  GetRunTaskResponseCpusInteger,
  TaskName,
  GetRunTaskResponseMemoryInteger,
  TaskTimestamp,
  TaskStatusMessage,
  TaskId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetRunTaskResponse(
    cpus: Optional[GetRunTaskResponseCpusInteger] = Optional.Absent,
    creationTime: Optional[TaskTimestamp] = Optional.Absent,
    logStream: Optional[TaskLogStream] = Optional.Absent,
    memory: Optional[GetRunTaskResponseMemoryInteger] = Optional.Absent,
    name: Optional[TaskName] = Optional.Absent,
    startTime: Optional[TaskTimestamp] = Optional.Absent,
    status: Optional[zio.aws.omics.model.TaskStatus] = Optional.Absent,
    statusMessage: Optional[TaskStatusMessage] = Optional.Absent,
    stopTime: Optional[TaskTimestamp] = Optional.Absent,
    taskId: Optional[TaskId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetRunTaskResponse = {
    import GetRunTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetRunTaskResponse
      .builder()
      .optionallyWith(
        cpus.map(value => GetRunTaskResponseCpusInteger.unwrap(value): Integer)
      )(_.cpus)
      .optionallyWith(
        creationTime.map(value => TaskTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        logStream.map(value => TaskLogStream.unwrap(value): java.lang.String)
      )(_.logStream)
      .optionallyWith(
        memory.map(value =>
          GetRunTaskResponseMemoryInteger.unwrap(value): Integer
        )
      )(_.memory)
      .optionallyWith(
        name.map(value => TaskName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        startTime.map(value => TaskTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          TaskStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        stopTime.map(value => TaskTimestamp.unwrap(value): Instant)
      )(_.stopTime)
      .optionallyWith(
        taskId.map(value => TaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetRunTaskResponse.ReadOnly =
    zio.aws.omics.model.GetRunTaskResponse.wrap(buildAwsValue())
}
object GetRunTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetRunTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetRunTaskResponse =
      zio.aws.omics.model.GetRunTaskResponse(
        cpus.map(value => value),
        creationTime.map(value => value),
        logStream.map(value => value),
        memory.map(value => value),
        name.map(value => value),
        startTime.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        stopTime.map(value => value),
        taskId.map(value => value)
      )
    def cpus: Optional[GetRunTaskResponseCpusInteger]
    def creationTime: Optional[TaskTimestamp]
    def logStream: Optional[TaskLogStream]
    def memory: Optional[GetRunTaskResponseMemoryInteger]
    def name: Optional[TaskName]
    def startTime: Optional[TaskTimestamp]
    def status: Optional[zio.aws.omics.model.TaskStatus]
    def statusMessage: Optional[TaskStatusMessage]
    def stopTime: Optional[TaskTimestamp]
    def taskId: Optional[TaskId]
    def getCpus: ZIO[Any, AwsError, GetRunTaskResponseCpusInteger] =
      AwsError.unwrapOptionField("cpus", cpus)
    def getCreationTime: ZIO[Any, AwsError, TaskTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLogStream: ZIO[Any, AwsError, TaskLogStream] =
      AwsError.unwrapOptionField("logStream", logStream)
    def getMemory: ZIO[Any, AwsError, GetRunTaskResponseMemoryInteger] =
      AwsError.unwrapOptionField("memory", memory)
    def getName: ZIO[Any, AwsError, TaskName] =
      AwsError.unwrapOptionField("name", name)
    def getStartTime: ZIO[Any, AwsError, TaskTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.TaskStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, TaskStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStopTime: ZIO[Any, AwsError, TaskTimestamp] =
      AwsError.unwrapOptionField("stopTime", stopTime)
    def getTaskId: ZIO[Any, AwsError, TaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetRunTaskResponse
  ) extends zio.aws.omics.model.GetRunTaskResponse.ReadOnly {
    override val cpus: Optional[GetRunTaskResponseCpusInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpus())
        .map(value =>
          zio.aws.omics.model.primitives.GetRunTaskResponseCpusInteger(value)
        )
    override val creationTime: Optional[TaskTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.omics.model.primitives.TaskTimestamp(value))
    override val logStream: Optional[TaskLogStream] = zio.aws.core.internal
      .optionalFromNullable(impl.logStream())
      .map(value => zio.aws.omics.model.primitives.TaskLogStream(value))
    override val memory: Optional[GetRunTaskResponseMemoryInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memory())
        .map(value =>
          zio.aws.omics.model.primitives.GetRunTaskResponseMemoryInteger(value)
        )
    override val name: Optional[TaskName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.TaskName(value))
    override val startTime: Optional[TaskTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.omics.model.primitives.TaskTimestamp(value))
    override val status: Optional[zio.aws.omics.model.TaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.TaskStatus.wrap(value))
    override val statusMessage: Optional[TaskStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.TaskStatusMessage(value))
    override val stopTime: Optional[TaskTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopTime())
      .map(value => zio.aws.omics.model.primitives.TaskTimestamp(value))
    override val taskId: Optional[TaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.taskId())
      .map(value => zio.aws.omics.model.primitives.TaskId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetRunTaskResponse
  ): zio.aws.omics.model.GetRunTaskResponse.ReadOnly = new Wrapper(impl)
}
