package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.SequenceStoreId
import scala.jdk.CollectionConverters._
final case class GetSequenceStoreRequest(id: SequenceStoreId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest = {
    import GetSequenceStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest
      .builder()
      .id(SequenceStoreId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetSequenceStoreRequest.ReadOnly =
    zio.aws.omics.model.GetSequenceStoreRequest.wrap(buildAwsValue())
}
object GetSequenceStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetSequenceStoreRequest =
      zio.aws.omics.model.GetSequenceStoreRequest(id)
    def id: SequenceStoreId
    def getId: ZIO[Any, Nothing, SequenceStoreId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest
  ) extends zio.aws.omics.model.GetSequenceStoreRequest.ReadOnly {
    override val id: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest
  ): zio.aws.omics.model.GetSequenceStoreRequest.ReadOnly = new Wrapper(impl)
}
