package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SequenceStoreId,
  SyntheticTimestamp_date_time,
  SequenceStoreDescription,
  SequenceStoreArn,
  SequenceStoreName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetSequenceStoreResponse(
    arn: SequenceStoreArn,
    creationTime: SyntheticTimestamp_date_time,
    description: Optional[SequenceStoreDescription] = Optional.Absent,
    id: SequenceStoreId,
    name: Optional[SequenceStoreName] = Optional.Absent,
    sseConfig: Optional[zio.aws.omics.model.SseConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse = {
    import GetSequenceStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse
      .builder()
      .arn(SequenceStoreArn.unwrap(arn): java.lang.String)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .optionallyWith(
        description.map(value =>
          SequenceStoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .id(SequenceStoreId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => SequenceStoreName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(sseConfig.map(value => value.buildAwsValue()))(
        _.sseConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetSequenceStoreResponse.ReadOnly =
    zio.aws.omics.model.GetSequenceStoreResponse.wrap(buildAwsValue())
}
object GetSequenceStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetSequenceStoreResponse =
      zio.aws.omics.model.GetSequenceStoreResponse(
        arn,
        creationTime,
        description.map(value => value),
        id,
        name.map(value => value),
        sseConfig.map(value => value.asEditable)
      )
    def arn: SequenceStoreArn
    def creationTime: SyntheticTimestamp_date_time
    def description: Optional[SequenceStoreDescription]
    def id: SequenceStoreId
    def name: Optional[SequenceStoreName]
    def sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly]
    def getArn: ZIO[Any, Nothing, SequenceStoreArn] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getDescription: ZIO[Any, AwsError, SequenceStoreDescription] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, Nothing, SequenceStoreId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, SequenceStoreName] =
      AwsError.unwrapOptionField("name", name)
    def getSseConfig
        : ZIO[Any, AwsError, zio.aws.omics.model.SseConfig.ReadOnly] =
      AwsError.unwrapOptionField("sseConfig", sseConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse
  ) extends zio.aws.omics.model.GetSequenceStoreResponse.ReadOnly {
    override val arn: SequenceStoreArn =
      zio.aws.omics.model.primitives.SequenceStoreArn(impl.arn())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val description: Optional[SequenceStoreDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.omics.model.primitives.SequenceStoreDescription(value)
        )
    override val id: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.id())
    override val name: Optional[SequenceStoreName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.SequenceStoreName(value))
    override val sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseConfig())
        .map(value => zio.aws.omics.model.SseConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse
  ): zio.aws.omics.model.GetSequenceStoreResponse.ReadOnly = new Wrapper(impl)
}
