package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetVariantImportJobRequest(jobId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest = {
    import GetVariantImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest
      .builder()
      .jobId(ResourceId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetVariantImportJobRequest.ReadOnly =
    zio.aws.omics.model.GetVariantImportJobRequest.wrap(buildAwsValue())
}
object GetVariantImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetVariantImportJobRequest =
      zio.aws.omics.model.GetVariantImportJobRequest(jobId)
    def jobId: ResourceId
    def getJobId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest
  ) extends zio.aws.omics.model.GetVariantImportJobRequest.ReadOnly {
    override val jobId: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest
  ): zio.aws.omics.model.GetVariantImportJobRequest.ReadOnly = new Wrapper(impl)
}
