package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  CreationTime,
  UpdateTime,
  JobStatusMsg,
  StoreName,
  CompletionTime,
  Arn,
  RunLeftNormalization,
  ResourceId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetVariantImportJobResponse(
    completionTime: Optional[CompletionTime] = Optional.Absent,
    creationTime: CreationTime,
    destinationName: StoreName,
    id: ResourceId,
    items: Iterable[zio.aws.omics.model.VariantImportItemDetail],
    roleArn: Arn,
    runLeftNormalization: RunLeftNormalization,
    status: zio.aws.omics.model.JobStatus,
    statusMessage: JobStatusMsg,
    updateTime: UpdateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse = {
    import GetVariantImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse
      .builder()
      .optionallyWith(
        completionTime.map(value => CompletionTime.unwrap(value): Instant)
      )(_.completionTime)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .destinationName(StoreName.unwrap(destinationName): java.lang.String)
      .id(ResourceId.unwrap(id): java.lang.String)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .runLeftNormalization(
        RunLeftNormalization.unwrap(runLeftNormalization): java.lang.Boolean
      )
      .status(status.unwrap)
      .statusMessage(JobStatusMsg.unwrap(statusMessage): java.lang.String)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetVariantImportJobResponse.ReadOnly =
    zio.aws.omics.model.GetVariantImportJobResponse.wrap(buildAwsValue())
}
object GetVariantImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetVariantImportJobResponse =
      zio.aws.omics.model.GetVariantImportJobResponse(
        completionTime.map(value => value),
        creationTime,
        destinationName,
        id,
        items.map { item =>
          item.asEditable
        },
        roleArn,
        runLeftNormalization,
        status,
        statusMessage,
        updateTime
      )
    def completionTime: Optional[CompletionTime]
    def creationTime: CreationTime
    def destinationName: StoreName
    def id: ResourceId
    def items: List[zio.aws.omics.model.VariantImportItemDetail.ReadOnly]
    def roleArn: Arn
    def runLeftNormalization: RunLeftNormalization
    def status: zio.aws.omics.model.JobStatus
    def statusMessage: JobStatusMsg
    def updateTime: UpdateTime
    def getCompletionTime: ZIO[Any, AwsError, CompletionTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getDestinationName: ZIO[Any, Nothing, StoreName] =
      ZIO.succeed(destinationName)
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.omics.model.VariantImportItemDetail.ReadOnly
    ]] = ZIO.succeed(items)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getRunLeftNormalization: ZIO[Any, Nothing, RunLeftNormalization] =
      ZIO.succeed(runLeftNormalization)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.JobStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, Nothing, JobStatusMsg] =
      ZIO.succeed(statusMessage)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse
  ) extends zio.aws.omics.model.GetVariantImportJobResponse.ReadOnly {
    override val completionTime: Optional[CompletionTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value => zio.aws.omics.model.primitives.CompletionTime(value))
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val destinationName: StoreName =
      zio.aws.omics.model.primitives.StoreName(impl.destinationName())
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val items
        : List[zio.aws.omics.model.VariantImportItemDetail.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.omics.model.VariantImportItemDetail.wrap(item)
      }
      .toList
    override val roleArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.roleArn())
    override val runLeftNormalization: RunLeftNormalization =
      zio.aws.omics.model.primitives
        .RunLeftNormalization(impl.runLeftNormalization())
    override val status: zio.aws.omics.model.JobStatus =
      zio.aws.omics.model.JobStatus.wrap(impl.status())
    override val statusMessage: JobStatusMsg =
      zio.aws.omics.model.primitives.JobStatusMsg(impl.statusMessage())
    override val updateTime: UpdateTime =
      zio.aws.omics.model.primitives.UpdateTime(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse
  ): zio.aws.omics.model.GetVariantImportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
