package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.omics.model.primitives.{
  CreationTime,
  UpdateTime,
  TagValue,
  Arn,
  ResourceId,
  StatusMessage,
  StoreDescription,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class GetVariantStoreResponse(
    creationTime: CreationTime,
    description: StoreDescription,
    id: ResourceId,
    name: String,
    reference: zio.aws.omics.model.ReferenceItem,
    sseConfig: zio.aws.omics.model.SseConfig,
    status: zio.aws.omics.model.StoreStatus,
    statusMessage: StatusMessage,
    storeArn: Arn,
    storeSizeBytes: Long,
    tags: Map[TagKey, TagValue],
    updateTime: UpdateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetVariantStoreResponse = {
    import GetVariantStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetVariantStoreResponse
      .builder()
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .description(StoreDescription.unwrap(description): java.lang.String)
      .id(ResourceId.unwrap(id): java.lang.String)
      .name(name: java.lang.String)
      .reference(reference.buildAwsValue())
      .sseConfig(sseConfig.buildAwsValue())
      .status(status.unwrap)
      .statusMessage(StatusMessage.unwrap(statusMessage): java.lang.String)
      .storeArn(Arn.unwrap(storeArn): java.lang.String)
      .storeSizeBytes(storeSizeBytes: java.lang.Long)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetVariantStoreResponse.ReadOnly =
    zio.aws.omics.model.GetVariantStoreResponse.wrap(buildAwsValue())
}
object GetVariantStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetVariantStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetVariantStoreResponse =
      zio.aws.omics.model.GetVariantStoreResponse(
        creationTime,
        description,
        id,
        name,
        reference.asEditable,
        sseConfig.asEditable,
        status,
        statusMessage,
        storeArn,
        storeSizeBytes,
        tags,
        updateTime
      )
    def creationTime: CreationTime
    def description: StoreDescription
    def id: ResourceId
    def name: String
    def reference: zio.aws.omics.model.ReferenceItem.ReadOnly
    def sseConfig: zio.aws.omics.model.SseConfig.ReadOnly
    def status: zio.aws.omics.model.StoreStatus
    def statusMessage: StatusMessage
    def storeArn: Arn
    def storeSizeBytes: Long
    def tags: Map[TagKey, TagValue]
    def updateTime: UpdateTime
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getDescription: ZIO[Any, Nothing, StoreDescription] =
      ZIO.succeed(description)
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getReference
        : ZIO[Any, Nothing, zio.aws.omics.model.ReferenceItem.ReadOnly] =
      ZIO.succeed(reference)
    def getSseConfig
        : ZIO[Any, Nothing, zio.aws.omics.model.SseConfig.ReadOnly] =
      ZIO.succeed(sseConfig)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.StoreStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, Nothing, StatusMessage] =
      ZIO.succeed(statusMessage)
    def getStoreArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(storeArn)
    def getStoreSizeBytes: ZIO[Any, Nothing, Long] = ZIO.succeed(storeSizeBytes)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetVariantStoreResponse
  ) extends zio.aws.omics.model.GetVariantStoreResponse.ReadOnly {
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val description: StoreDescription =
      zio.aws.omics.model.primitives.StoreDescription(impl.description())
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val name: String = impl.name(): String
    override val reference: zio.aws.omics.model.ReferenceItem.ReadOnly =
      zio.aws.omics.model.ReferenceItem.wrap(impl.reference())
    override val sseConfig: zio.aws.omics.model.SseConfig.ReadOnly =
      zio.aws.omics.model.SseConfig.wrap(impl.sseConfig())
    override val status: zio.aws.omics.model.StoreStatus =
      zio.aws.omics.model.StoreStatus.wrap(impl.status())
    override val statusMessage: StatusMessage =
      zio.aws.omics.model.primitives.StatusMessage(impl.statusMessage())
    override val storeArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.storeArn())
    override val storeSizeBytes: Long = impl.storeSizeBytes(): Long
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.omics.model.primitives
          .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
      })
      .toMap
    override val updateTime: UpdateTime =
      zio.aws.omics.model.primitives.UpdateTime(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetVariantStoreResponse
  ): zio.aws.omics.model.GetVariantStoreResponse.ReadOnly = new Wrapper(impl)
}
