package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.WorkflowId
import scala.jdk.CollectionConverters._
final case class GetWorkflowRequest(
    export: Optional[Iterable[zio.aws.omics.model.WorkflowExport]] =
      Optional.Absent,
    id: WorkflowId,
    `type`: Optional[zio.aws.omics.model.WorkflowType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetWorkflowRequest = {
    import GetWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetWorkflowRequest
      .builder()
      .optionallyWith(
        export.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.exportWithStrings)
      .id(WorkflowId.unwrap(id): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetWorkflowRequest.ReadOnly =
    zio.aws.omics.model.GetWorkflowRequest.wrap(buildAwsValue())
}
object GetWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetWorkflowRequest =
      zio.aws.omics.model.GetWorkflowRequest(
        export.map(value => value),
        id,
        `type`.map(value => value)
      )
    def export: Optional[List[zio.aws.omics.model.WorkflowExport]]
    def id: WorkflowId
    def `type`: Optional[zio.aws.omics.model.WorkflowType]
    def getExport
        : ZIO[Any, AwsError, List[zio.aws.omics.model.WorkflowExport]] =
      AwsError.unwrapOptionField("export", export)
    def getId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(id)
    def getType: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetWorkflowRequest
  ) extends zio.aws.omics.model.GetWorkflowRequest.ReadOnly {
    override val export: Optional[List[zio.aws.omics.model.WorkflowExport]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.export())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.WorkflowExport.wrap(item)
          }.toList
        )
    override val id: WorkflowId =
      zio.aws.omics.model.primitives.WorkflowId(impl.id())
    override val `type`: Optional[zio.aws.omics.model.WorkflowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.omics.model.WorkflowType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetWorkflowRequest
  ): zio.aws.omics.model.GetWorkflowRequest.ReadOnly = new Wrapper(impl)
}
