package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  WorkflowDescription,
  GetWorkflowResponseStorageCapacityInteger,
  WorkflowArn,
  WorkflowDefinition,
  WorkflowStatusMessage,
  WorkflowMain,
  TagValue,
  WorkflowParameterName,
  WorkflowId,
  WorkflowTimestamp,
  TagKey,
  WorkflowDigest,
  WorkflowName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetWorkflowResponse(
    arn: Optional[WorkflowArn] = Optional.Absent,
    creationTime: Optional[WorkflowTimestamp] = Optional.Absent,
    definition: Optional[WorkflowDefinition] = Optional.Absent,
    description: Optional[WorkflowDescription] = Optional.Absent,
    digest: Optional[WorkflowDigest] = Optional.Absent,
    engine: Optional[zio.aws.omics.model.WorkflowEngine] = Optional.Absent,
    id: Optional[WorkflowId] = Optional.Absent,
    main: Optional[WorkflowMain] = Optional.Absent,
    name: Optional[WorkflowName] = Optional.Absent,
    parameterTemplate: Optional[
      Map[WorkflowParameterName, zio.aws.omics.model.WorkflowParameter]
    ] = Optional.Absent,
    status: Optional[zio.aws.omics.model.WorkflowStatus] = Optional.Absent,
    statusMessage: Optional[WorkflowStatusMessage] = Optional.Absent,
    storageCapacity: Optional[GetWorkflowResponseStorageCapacityInteger] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    `type`: Optional[zio.aws.omics.model.WorkflowType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetWorkflowResponse = {
    import GetWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetWorkflowResponse
      .builder()
      .optionallyWith(
        arn.map(value => WorkflowArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        creationTime.map(value => WorkflowTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        definition.map(value =>
          WorkflowDefinition.unwrap(value): java.lang.String
        )
      )(_.definition)
      .optionallyWith(
        description.map(value =>
          WorkflowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        digest.map(value => WorkflowDigest.unwrap(value): java.lang.String)
      )(_.digest)
      .optionallyWith(engine.map(value => value.unwrap))(_.engine)
      .optionallyWith(
        id.map(value => WorkflowId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        main.map(value => WorkflowMain.unwrap(value): java.lang.String)
      )(_.main)
      .optionallyWith(
        name.map(value => WorkflowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        parameterTemplate.map(value =>
          value
            .map({ case (key, value) =>
              (WorkflowParameterName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.parameterTemplate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          WorkflowStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        storageCapacity.map(value =>
          GetWorkflowResponseStorageCapacityInteger.unwrap(value): Integer
        )
      )(_.storageCapacity)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetWorkflowResponse.ReadOnly =
    zio.aws.omics.model.GetWorkflowResponse.wrap(buildAwsValue())
}
object GetWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetWorkflowResponse =
      zio.aws.omics.model.GetWorkflowResponse(
        arn.map(value => value),
        creationTime.map(value => value),
        definition.map(value => value),
        description.map(value => value),
        digest.map(value => value),
        engine.map(value => value),
        id.map(value => value),
        main.map(value => value),
        name.map(value => value),
        parameterTemplate.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        status.map(value => value),
        statusMessage.map(value => value),
        storageCapacity.map(value => value),
        tags.map(value => value),
        `type`.map(value => value)
      )
    def arn: Optional[WorkflowArn]
    def creationTime: Optional[WorkflowTimestamp]
    def definition: Optional[WorkflowDefinition]
    def description: Optional[WorkflowDescription]
    def digest: Optional[WorkflowDigest]
    def engine: Optional[zio.aws.omics.model.WorkflowEngine]
    def id: Optional[WorkflowId]
    def main: Optional[WorkflowMain]
    def name: Optional[WorkflowName]
    def parameterTemplate: Optional[
      Map[WorkflowParameterName, zio.aws.omics.model.WorkflowParameter.ReadOnly]
    ]
    def status: Optional[zio.aws.omics.model.WorkflowStatus]
    def statusMessage: Optional[WorkflowStatusMessage]
    def storageCapacity: Optional[GetWorkflowResponseStorageCapacityInteger]
    def tags: Optional[Map[TagKey, TagValue]]
    def `type`: Optional[zio.aws.omics.model.WorkflowType]
    def getArn: ZIO[Any, AwsError, WorkflowArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, WorkflowTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDefinition: ZIO[Any, AwsError, WorkflowDefinition] =
      AwsError.unwrapOptionField("definition", definition)
    def getDescription: ZIO[Any, AwsError, WorkflowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDigest: ZIO[Any, AwsError, WorkflowDigest] =
      AwsError.unwrapOptionField("digest", digest)
    def getEngine: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowEngine] =
      AwsError.unwrapOptionField("engine", engine)
    def getId: ZIO[Any, AwsError, WorkflowId] =
      AwsError.unwrapOptionField("id", id)
    def getMain: ZIO[Any, AwsError, WorkflowMain] =
      AwsError.unwrapOptionField("main", main)
    def getName: ZIO[Any, AwsError, WorkflowName] =
      AwsError.unwrapOptionField("name", name)
    def getParameterTemplate: ZIO[Any, AwsError, Map[
      WorkflowParameterName,
      zio.aws.omics.model.WorkflowParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterTemplate", parameterTemplate)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, WorkflowStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStorageCapacity
        : ZIO[Any, AwsError, GetWorkflowResponseStorageCapacityInteger] =
      AwsError.unwrapOptionField("storageCapacity", storageCapacity)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetWorkflowResponse
  ) extends zio.aws.omics.model.GetWorkflowResponse.ReadOnly {
    override val arn: Optional[WorkflowArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.omics.model.primitives.WorkflowArn(value))
    override val creationTime: Optional[WorkflowTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => zio.aws.omics.model.primitives.WorkflowTimestamp(value))
    override val definition: Optional[WorkflowDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definition())
        .map(value => zio.aws.omics.model.primitives.WorkflowDefinition(value))
    override val description: Optional[WorkflowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.omics.model.primitives.WorkflowDescription(value))
    override val digest: Optional[WorkflowDigest] = zio.aws.core.internal
      .optionalFromNullable(impl.digest())
      .map(value => zio.aws.omics.model.primitives.WorkflowDigest(value))
    override val engine: Optional[zio.aws.omics.model.WorkflowEngine] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engine())
        .map(value => zio.aws.omics.model.WorkflowEngine.wrap(value))
    override val id: Optional[WorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.omics.model.primitives.WorkflowId(value))
    override val main: Optional[WorkflowMain] = zio.aws.core.internal
      .optionalFromNullable(impl.main())
      .map(value => zio.aws.omics.model.primitives.WorkflowMain(value))
    override val name: Optional[WorkflowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.WorkflowName(value))
    override val parameterTemplate: Optional[
      Map[WorkflowParameterName, zio.aws.omics.model.WorkflowParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterTemplate())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives.WorkflowParameterName(
              key
            ) -> zio.aws.omics.model.WorkflowParameter.wrap(value)
          })
          .toMap
      )
    override val status: Optional[zio.aws.omics.model.WorkflowStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.WorkflowStatus.wrap(value))
    override val statusMessage: Optional[WorkflowStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.omics.model.primitives.WorkflowStatusMessage(value)
        )
    override val storageCapacity
        : Optional[GetWorkflowResponseStorageCapacityInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageCapacity())
        .map(value =>
          zio.aws.omics.model.primitives
            .GetWorkflowResponseStorageCapacityInteger(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: Optional[zio.aws.omics.model.WorkflowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.omics.model.WorkflowType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetWorkflowResponse
  ): zio.aws.omics.model.GetWorkflowResponse.ReadOnly = new Wrapper(impl)
}
