package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SequenceStoreId,
  RoleArn,
  ImportJobId,
  SyntheticTimestamp_date_time
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ImportReadSetJobItem(
    completionTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time,
    id: ImportJobId,
    roleArn: RoleArn,
    sequenceStoreId: SequenceStoreId,
    status: zio.aws.omics.model.ReadSetImportJobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ImportReadSetJobItem = {
    import ImportReadSetJobItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ImportReadSetJobItem
      .builder()
      .optionallyWith(
        completionTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.completionTime)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .id(ImportJobId.unwrap(id): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ImportReadSetJobItem.ReadOnly =
    zio.aws.omics.model.ImportReadSetJobItem.wrap(buildAwsValue())
}
object ImportReadSetJobItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ImportReadSetJobItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ImportReadSetJobItem =
      zio.aws.omics.model.ImportReadSetJobItem(
        completionTime.map(value => value),
        creationTime,
        id,
        roleArn,
        sequenceStoreId,
        status
      )
    def completionTime: Optional[SyntheticTimestamp_date_time]
    def creationTime: SyntheticTimestamp_date_time
    def id: ImportJobId
    def roleArn: RoleArn
    def sequenceStoreId: SequenceStoreId
    def status: zio.aws.omics.model.ReadSetImportJobStatus
    def getCompletionTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getId: ZIO[Any, Nothing, ImportJobId] = ZIO.succeed(id)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetImportJobStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ImportReadSetJobItem
  ) extends zio.aws.omics.model.ImportReadSetJobItem.ReadOnly {
    override val completionTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val id: ImportJobId =
      zio.aws.omics.model.primitives.ImportJobId(impl.id())
    override val roleArn: RoleArn =
      zio.aws.omics.model.primitives.RoleArn(impl.roleArn())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val status: zio.aws.omics.model.ReadSetImportJobStatus =
      zio.aws.omics.model.ReadSetImportJobStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ImportReadSetJobItem
  ): zio.aws.omics.model.ImportReadSetJobItem.ReadOnly = new Wrapper(impl)
}
