package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  ReadSetName,
  SubjectId,
  SampleId,
  TagValue,
  JobStatusMessage,
  ReadSetDescription,
  GeneratedFrom,
  ReferenceArn,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class ImportReadSetSourceItem(
    description: Optional[ReadSetDescription] = Optional.Absent,
    generatedFrom: Optional[GeneratedFrom] = Optional.Absent,
    name: Optional[ReadSetName] = Optional.Absent,
    referenceArn: Optional[ReferenceArn] = Optional.Absent,
    sampleId: SampleId,
    sourceFileType: zio.aws.omics.model.FileType,
    sourceFiles: zio.aws.omics.model.SourceFiles,
    status: zio.aws.omics.model.ReadSetImportJobItemStatus,
    statusMessage: Optional[JobStatusMessage] = Optional.Absent,
    subjectId: SubjectId,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ImportReadSetSourceItem = {
    import ImportReadSetSourceItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ImportReadSetSourceItem
      .builder()
      .optionallyWith(
        description.map(value =>
          ReadSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        generatedFrom.map(value =>
          GeneratedFrom.unwrap(value): java.lang.String
        )
      )(_.generatedFrom)
      .optionallyWith(
        name.map(value => ReadSetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        referenceArn.map(value => ReferenceArn.unwrap(value): java.lang.String)
      )(_.referenceArn)
      .sampleId(SampleId.unwrap(sampleId): java.lang.String)
      .sourceFileType(sourceFileType.unwrap)
      .sourceFiles(sourceFiles.buildAwsValue())
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          JobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .subjectId(SubjectId.unwrap(subjectId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ImportReadSetSourceItem.ReadOnly =
    zio.aws.omics.model.ImportReadSetSourceItem.wrap(buildAwsValue())
}
object ImportReadSetSourceItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ImportReadSetSourceItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ImportReadSetSourceItem =
      zio.aws.omics.model.ImportReadSetSourceItem(
        description.map(value => value),
        generatedFrom.map(value => value),
        name.map(value => value),
        referenceArn.map(value => value),
        sampleId,
        sourceFileType,
        sourceFiles.asEditable,
        status,
        statusMessage.map(value => value),
        subjectId,
        tags.map(value => value)
      )
    def description: Optional[ReadSetDescription]
    def generatedFrom: Optional[GeneratedFrom]
    def name: Optional[ReadSetName]
    def referenceArn: Optional[ReferenceArn]
    def sampleId: SampleId
    def sourceFileType: zio.aws.omics.model.FileType
    def sourceFiles: zio.aws.omics.model.SourceFiles.ReadOnly
    def status: zio.aws.omics.model.ReadSetImportJobItemStatus
    def statusMessage: Optional[JobStatusMessage]
    def subjectId: SubjectId
    def tags: Optional[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, ReadSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getGeneratedFrom: ZIO[Any, AwsError, GeneratedFrom] =
      AwsError.unwrapOptionField("generatedFrom", generatedFrom)
    def getName: ZIO[Any, AwsError, ReadSetName] =
      AwsError.unwrapOptionField("name", name)
    def getReferenceArn: ZIO[Any, AwsError, ReferenceArn] =
      AwsError.unwrapOptionField("referenceArn", referenceArn)
    def getSampleId: ZIO[Any, Nothing, SampleId] = ZIO.succeed(sampleId)
    def getSourceFileType: ZIO[Any, Nothing, zio.aws.omics.model.FileType] =
      ZIO.succeed(sourceFileType)
    def getSourceFiles
        : ZIO[Any, Nothing, zio.aws.omics.model.SourceFiles.ReadOnly] =
      ZIO.succeed(sourceFiles)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetImportJobItemStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, JobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getSubjectId: ZIO[Any, Nothing, SubjectId] = ZIO.succeed(subjectId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ImportReadSetSourceItem
  ) extends zio.aws.omics.model.ImportReadSetSourceItem.ReadOnly {
    override val description: Optional[ReadSetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.omics.model.primitives.ReadSetDescription(value))
    override val generatedFrom: Optional[GeneratedFrom] = zio.aws.core.internal
      .optionalFromNullable(impl.generatedFrom())
      .map(value => zio.aws.omics.model.primitives.GeneratedFrom(value))
    override val name: Optional[ReadSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReadSetName(value))
    override val referenceArn: Optional[ReferenceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceArn())
      .map(value => zio.aws.omics.model.primitives.ReferenceArn(value))
    override val sampleId: SampleId =
      zio.aws.omics.model.primitives.SampleId(impl.sampleId())
    override val sourceFileType: zio.aws.omics.model.FileType =
      zio.aws.omics.model.FileType.wrap(impl.sourceFileType())
    override val sourceFiles: zio.aws.omics.model.SourceFiles.ReadOnly =
      zio.aws.omics.model.SourceFiles.wrap(impl.sourceFiles())
    override val status: zio.aws.omics.model.ReadSetImportJobItemStatus =
      zio.aws.omics.model.ReadSetImportJobItemStatus.wrap(impl.status())
    override val statusMessage: Optional[JobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.JobStatusMessage(value))
    override val subjectId: SubjectId =
      zio.aws.omics.model.primitives.SubjectId(impl.subjectId())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ImportReadSetSourceItem
  ): zio.aws.omics.model.ImportReadSetSourceItem.ReadOnly = new Wrapper(impl)
}
