package zio.aws.omics.model
import zio.aws.omics.model.primitives.SyntheticTimestamp_date_time
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ImportReferenceFilter(
    createdAfter: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBefore: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    status: Optional[zio.aws.omics.model.ReferenceImportJobStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ImportReferenceFilter = {
    import ImportReferenceFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ImportReferenceFilter
      .builder()
      .optionallyWith(
        createdAfter.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdBefore)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ImportReferenceFilter.ReadOnly =
    zio.aws.omics.model.ImportReferenceFilter.wrap(buildAwsValue())
}
object ImportReferenceFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ImportReferenceFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ImportReferenceFilter =
      zio.aws.omics.model.ImportReferenceFilter(
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        status.map(value => value)
      )
    def createdAfter: Optional[SyntheticTimestamp_date_time]
    def createdBefore: Optional[SyntheticTimestamp_date_time]
    def status: Optional[zio.aws.omics.model.ReferenceImportJobStatus]
    def getCreatedAfter: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.omics.model.ReferenceImportJobStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ImportReferenceFilter
  ) extends zio.aws.omics.model.ImportReferenceFilter.ReadOnly {
    override val createdAfter: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAfter())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBefore: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBefore())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val status
        : Optional[zio.aws.omics.model.ReferenceImportJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.ReferenceImportJobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ImportReferenceFilter
  ): zio.aws.omics.model.ImportReferenceFilter.ReadOnly = new Wrapper(impl)
}
