package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  S3Uri,
  TagValue,
  JobStatusMessage,
  ReferenceName,
  ReferenceDescription,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class ImportReferenceSourceItem(
    description: Optional[ReferenceDescription] = Optional.Absent,
    name: Optional[ReferenceName] = Optional.Absent,
    sourceFile: Optional[S3Uri] = Optional.Absent,
    status: zio.aws.omics.model.ReferenceImportJobItemStatus,
    statusMessage: Optional[JobStatusMessage] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ImportReferenceSourceItem = {
    import ImportReferenceSourceItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ImportReferenceSourceItem
      .builder()
      .optionallyWith(
        description.map(value =>
          ReferenceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        name.map(value => ReferenceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        sourceFile.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.sourceFile)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          JobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ImportReferenceSourceItem.ReadOnly =
    zio.aws.omics.model.ImportReferenceSourceItem.wrap(buildAwsValue())
}
object ImportReferenceSourceItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ImportReferenceSourceItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ImportReferenceSourceItem =
      zio.aws.omics.model.ImportReferenceSourceItem(
        description.map(value => value),
        name.map(value => value),
        sourceFile.map(value => value),
        status,
        statusMessage.map(value => value),
        tags.map(value => value)
      )
    def description: Optional[ReferenceDescription]
    def name: Optional[ReferenceName]
    def sourceFile: Optional[S3Uri]
    def status: zio.aws.omics.model.ReferenceImportJobItemStatus
    def statusMessage: Optional[JobStatusMessage]
    def tags: Optional[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, ReferenceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, ReferenceName] =
      AwsError.unwrapOptionField("name", name)
    def getSourceFile: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("sourceFile", sourceFile)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReferenceImportJobItemStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, JobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ImportReferenceSourceItem
  ) extends zio.aws.omics.model.ImportReferenceSourceItem.ReadOnly {
    override val description: Optional[ReferenceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.omics.model.primitives.ReferenceDescription(value)
        )
    override val name: Optional[ReferenceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReferenceName(value))
    override val sourceFile: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceFile())
      .map(value => zio.aws.omics.model.primitives.S3Uri(value))
    override val status: zio.aws.omics.model.ReferenceImportJobItemStatus =
      zio.aws.omics.model.ReferenceImportJobItemStatus.wrap(impl.status())
    override val statusMessage: Optional[JobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.JobStatusMessage(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ImportReferenceSourceItem
  ): zio.aws.omics.model.ImportReferenceSourceItem.ReadOnly = new Wrapper(impl)
}
