package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.omics.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.JobStatus
  ): zio.aws.omics.model.JobStatus = value match {
    case software.amazon.awssdk.services.omics.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.JobStatus.SUBMITTED =>
      val r = SUBMITTED
      r
    case software.amazon.awssdk.services.omics.model.JobStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.omics.model.JobStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.omics.model.JobStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.omics.model.JobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.omics.model.JobStatus.COMPLETED_WITH_FAILURES =>
      val r = COMPLETED_WITH_FAILURES
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.JobStatus =
      software.amazon.awssdk.services.omics.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUBMITTED extends zio.aws.omics.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.JobStatus =
      software.amazon.awssdk.services.omics.model.JobStatus.SUBMITTED
  }
  case object IN_PROGRESS extends zio.aws.omics.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.JobStatus =
      software.amazon.awssdk.services.omics.model.JobStatus.IN_PROGRESS
  }
  case object CANCELLED extends zio.aws.omics.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.JobStatus =
      software.amazon.awssdk.services.omics.model.JobStatus.CANCELLED
  }
  case object COMPLETED extends zio.aws.omics.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.JobStatus =
      software.amazon.awssdk.services.omics.model.JobStatus.COMPLETED
  }
  case object FAILED extends zio.aws.omics.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.JobStatus =
      software.amazon.awssdk.services.omics.model.JobStatus.FAILED
  }
  case object COMPLETED_WITH_FAILURES extends zio.aws.omics.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.omics.model.JobStatus =
      software.amazon.awssdk.services.omics.model.JobStatus.COMPLETED_WITH_FAILURES
  }
}
