package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ListAnnotationImportJobsRequestNextTokenString,
  ListAnnotationImportJobsRequestMaxResultsInteger,
  ResourceIdentifier
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAnnotationImportJobsRequest(
    filter: Optional[zio.aws.omics.model.ListAnnotationImportJobsFilter] =
      Optional.Absent,
    ids: Optional[Iterable[ResourceIdentifier]] = Optional.Absent,
    maxResults: Optional[ListAnnotationImportJobsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[ListAnnotationImportJobsRequestNextTokenString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest = {
    import ListAnnotationImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            ResourceIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(
        maxResults.map(value =>
          ListAnnotationImportJobsRequestMaxResultsInteger.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          ListAnnotationImportJobsRequestNextTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListAnnotationImportJobsRequest.ReadOnly =
    zio.aws.omics.model.ListAnnotationImportJobsRequest.wrap(buildAwsValue())
}
object ListAnnotationImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListAnnotationImportJobsRequest =
      zio.aws.omics.model.ListAnnotationImportJobsRequest(
        filter.map(value => value.asEditable),
        ids.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter
        : Optional[zio.aws.omics.model.ListAnnotationImportJobsFilter.ReadOnly]
    def ids: Optional[List[ResourceIdentifier]]
    def maxResults: Optional[ListAnnotationImportJobsRequestMaxResultsInteger]
    def nextToken: Optional[ListAnnotationImportJobsRequestNextTokenString]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.omics.model.ListAnnotationImportJobsFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getIds: ZIO[Any, AwsError, List[ResourceIdentifier]] =
      AwsError.unwrapOptionField("ids", ids)
    def getMaxResults
        : ZIO[Any, AwsError, ListAnnotationImportJobsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken
        : ZIO[Any, AwsError, ListAnnotationImportJobsRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest
  ) extends zio.aws.omics.model.ListAnnotationImportJobsRequest.ReadOnly {
    override val filter: Optional[
      zio.aws.omics.model.ListAnnotationImportJobsFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filter())
      .map(value =>
        zio.aws.omics.model.ListAnnotationImportJobsFilter.wrap(value)
      )
    override val ids: Optional[List[ResourceIdentifier]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.omics.model.primitives.ResourceIdentifier(item)
        }.toList
      )
    override val maxResults
        : Optional[ListAnnotationImportJobsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListAnnotationImportJobsRequestMaxResultsInteger(value)
        )
    override val nextToken
        : Optional[ListAnnotationImportJobsRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListAnnotationImportJobsRequestNextTokenString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest
  ): zio.aws.omics.model.ListAnnotationImportJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
