package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAnnotationImportJobsResponse(
    annotationImportJobs: Optional[
      Iterable[zio.aws.omics.model.AnnotationImportJobItem]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse = {
    import ListAnnotationImportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse
      .builder()
      .optionallyWith(
        annotationImportJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.annotationImportJobs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.ListAnnotationImportJobsResponse.ReadOnly =
    zio.aws.omics.model.ListAnnotationImportJobsResponse.wrap(buildAwsValue())
}
object ListAnnotationImportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListAnnotationImportJobsResponse =
      zio.aws.omics.model.ListAnnotationImportJobsResponse(
        annotationImportJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def annotationImportJobs
        : Optional[List[zio.aws.omics.model.AnnotationImportJobItem.ReadOnly]]
    def nextToken: Optional[String]
    def getAnnotationImportJobs: ZIO[Any, AwsError, List[
      zio.aws.omics.model.AnnotationImportJobItem.ReadOnly
    ]] =
      AwsError.unwrapOptionField("annotationImportJobs", annotationImportJobs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse
  ) extends zio.aws.omics.model.ListAnnotationImportJobsResponse.ReadOnly {
    override val annotationImportJobs
        : Optional[List[zio.aws.omics.model.AnnotationImportJobItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.annotationImportJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.AnnotationImportJobItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse
  ): zio.aws.omics.model.ListAnnotationImportJobsResponse.ReadOnly =
    new Wrapper(impl)
}
