package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ListAnnotationStoresRequestNextTokenString,
  ListAnnotationStoresRequestMaxResultsInteger,
  ResourceIdentifier
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAnnotationStoresRequest(
    filter: Optional[zio.aws.omics.model.ListAnnotationStoresFilter] =
      Optional.Absent,
    ids: Optional[Iterable[ResourceIdentifier]] = Optional.Absent,
    maxResults: Optional[ListAnnotationStoresRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[ListAnnotationStoresRequestNextTokenString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest = {
    import ListAnnotationStoresRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            ResourceIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(
        maxResults.map(value =>
          ListAnnotationStoresRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          ListAnnotationStoresRequestNextTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListAnnotationStoresRequest.ReadOnly =
    zio.aws.omics.model.ListAnnotationStoresRequest.wrap(buildAwsValue())
}
object ListAnnotationStoresRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListAnnotationStoresRequest =
      zio.aws.omics.model.ListAnnotationStoresRequest(
        filter.map(value => value.asEditable),
        ids.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter
        : Optional[zio.aws.omics.model.ListAnnotationStoresFilter.ReadOnly]
    def ids: Optional[List[ResourceIdentifier]]
    def maxResults: Optional[ListAnnotationStoresRequestMaxResultsInteger]
    def nextToken: Optional[ListAnnotationStoresRequestNextTokenString]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.omics.model.ListAnnotationStoresFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getIds: ZIO[Any, AwsError, List[ResourceIdentifier]] =
      AwsError.unwrapOptionField("ids", ids)
    def getMaxResults
        : ZIO[Any, AwsError, ListAnnotationStoresRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken
        : ZIO[Any, AwsError, ListAnnotationStoresRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest
  ) extends zio.aws.omics.model.ListAnnotationStoresRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.omics.model.ListAnnotationStoresFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.omics.model.ListAnnotationStoresFilter.wrap(value)
        )
    override val ids: Optional[List[ResourceIdentifier]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.omics.model.primitives.ResourceIdentifier(item)
        }.toList
      )
    override val maxResults
        : Optional[ListAnnotationStoresRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListAnnotationStoresRequestMaxResultsInteger(value)
        )
    override val nextToken
        : Optional[ListAnnotationStoresRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListAnnotationStoresRequestNextTokenString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest
  ): zio.aws.omics.model.ListAnnotationStoresRequest.ReadOnly = new Wrapper(
    impl
  )
}
