package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SequenceStoreId,
  NextToken,
  ListReadSetActivationJobsRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReadSetActivationJobsRequest(
    filter: Optional[zio.aws.omics.model.ActivateReadSetFilter] =
      Optional.Absent,
    maxResults: Optional[ListReadSetActivationJobsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sequenceStoreId: SequenceStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest = {
    import ListReadSetActivationJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        maxResults.map(value =>
          ListReadSetActivationJobsRequestMaxResultsInteger.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.ListReadSetActivationJobsRequest.ReadOnly =
    zio.aws.omics.model.ListReadSetActivationJobsRequest.wrap(buildAwsValue())
}
object ListReadSetActivationJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReadSetActivationJobsRequest =
      zio.aws.omics.model.ListReadSetActivationJobsRequest(
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sequenceStoreId
      )
    def filter: Optional[zio.aws.omics.model.ActivateReadSetFilter.ReadOnly]
    def maxResults: Optional[ListReadSetActivationJobsRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def sequenceStoreId: SequenceStoreId
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.omics.model.ActivateReadSetFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      ListReadSetActivationJobsRequestMaxResultsInteger
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest
  ) extends zio.aws.omics.model.ListReadSetActivationJobsRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.omics.model.ActivateReadSetFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.omics.model.ActivateReadSetFilter.wrap(value))
    override val maxResults
        : Optional[ListReadSetActivationJobsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListReadSetActivationJobsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest
  ): zio.aws.omics.model.ListReadSetActivationJobsRequest.ReadOnly =
    new Wrapper(impl)
}
