package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListReadSetExportJobsResponse(
    exportJobs: Optional[Iterable[zio.aws.omics.model.ExportReadSetJobDetail]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse = {
    import ListReadSetExportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse
      .builder()
      .optionallyWith(
        exportJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exportJobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReadSetExportJobsResponse.ReadOnly =
    zio.aws.omics.model.ListReadSetExportJobsResponse.wrap(buildAwsValue())
}
object ListReadSetExportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReadSetExportJobsResponse =
      zio.aws.omics.model.ListReadSetExportJobsResponse(
        exportJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def exportJobs
        : Optional[List[zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getExportJobs: ZIO[Any, AwsError, List[
      zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("exportJobs", exportJobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse
  ) extends zio.aws.omics.model.ListReadSetExportJobsResponse.ReadOnly {
    override val exportJobs
        : Optional[List[zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.ExportReadSetJobDetail.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse
  ): zio.aws.omics.model.ListReadSetExportJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
