package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListReadSetImportJobsResponse(
    importJobs: Optional[Iterable[zio.aws.omics.model.ImportReadSetJobItem]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse = {
    import ListReadSetImportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse
      .builder()
      .optionallyWith(
        importJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importJobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReadSetImportJobsResponse.ReadOnly =
    zio.aws.omics.model.ListReadSetImportJobsResponse.wrap(buildAwsValue())
}
object ListReadSetImportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReadSetImportJobsResponse =
      zio.aws.omics.model.ListReadSetImportJobsResponse(
        importJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def importJobs
        : Optional[List[zio.aws.omics.model.ImportReadSetJobItem.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getImportJobs: ZIO[Any, AwsError, List[
      zio.aws.omics.model.ImportReadSetJobItem.ReadOnly
    ]] = AwsError.unwrapOptionField("importJobs", importJobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse
  ) extends zio.aws.omics.model.ListReadSetImportJobsResponse.ReadOnly {
    override val importJobs
        : Optional[List[zio.aws.omics.model.ImportReadSetJobItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.ImportReadSetJobItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse
  ): zio.aws.omics.model.ListReadSetImportJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
