package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SequenceStoreId,
  NextToken,
  ListReadSetsRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReadSetsRequest(
    filter: Optional[zio.aws.omics.model.ReadSetFilter] = Optional.Absent,
    maxResults: Optional[ListReadSetsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sequenceStoreId: SequenceStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReadSetsRequest = {
    import ListReadSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReadSetsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        maxResults.map(value =>
          ListReadSetsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReadSetsRequest.ReadOnly =
    zio.aws.omics.model.ListReadSetsRequest.wrap(buildAwsValue())
}
object ListReadSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReadSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReadSetsRequest =
      zio.aws.omics.model.ListReadSetsRequest(
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sequenceStoreId
      )
    def filter: Optional[zio.aws.omics.model.ReadSetFilter.ReadOnly]
    def maxResults: Optional[ListReadSetsRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def sequenceStoreId: SequenceStoreId
    def getFilter
        : ZIO[Any, AwsError, zio.aws.omics.model.ReadSetFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getMaxResults
        : ZIO[Any, AwsError, ListReadSetsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetsRequest
  ) extends zio.aws.omics.model.ListReadSetsRequest.ReadOnly {
    override val filter: Optional[zio.aws.omics.model.ReadSetFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.omics.model.ReadSetFilter.wrap(value))
    override val maxResults: Optional[ListReadSetsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListReadSetsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetsRequest
  ): zio.aws.omics.model.ListReadSetsRequest.ReadOnly = new Wrapper(impl)
}
