package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ReferenceStoreId,
  NextToken,
  ListReferenceImportJobsRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReferenceImportJobsRequest(
    filter: Optional[zio.aws.omics.model.ImportReferenceFilter] =
      Optional.Absent,
    maxResults: Optional[ListReferenceImportJobsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    referenceStoreId: ReferenceStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest = {
    import ListReferenceImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        maxResults.map(value =>
          ListReferenceImportJobsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .referenceStoreId(
        ReferenceStoreId.unwrap(referenceStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReferenceImportJobsRequest.ReadOnly =
    zio.aws.omics.model.ListReferenceImportJobsRequest.wrap(buildAwsValue())
}
object ListReferenceImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReferenceImportJobsRequest =
      zio.aws.omics.model.ListReferenceImportJobsRequest(
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        referenceStoreId
      )
    def filter: Optional[zio.aws.omics.model.ImportReferenceFilter.ReadOnly]
    def maxResults: Optional[ListReferenceImportJobsRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def referenceStoreId: ReferenceStoreId
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.omics.model.ImportReferenceFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults
        : ZIO[Any, AwsError, ListReferenceImportJobsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReferenceStoreId: ZIO[Any, Nothing, ReferenceStoreId] =
      ZIO.succeed(referenceStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest
  ) extends zio.aws.omics.model.ListReferenceImportJobsRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.omics.model.ImportReferenceFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.omics.model.ImportReferenceFilter.wrap(value))
    override val maxResults
        : Optional[ListReferenceImportJobsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListReferenceImportJobsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val referenceStoreId: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.referenceStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest
  ): zio.aws.omics.model.ListReferenceImportJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
