package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListReferenceImportJobsResponse(
    importJobs: Optional[Iterable[zio.aws.omics.model.ImportReferenceJobItem]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse = {
    import ListReferenceImportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse
      .builder()
      .optionallyWith(
        importJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importJobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReferenceImportJobsResponse.ReadOnly =
    zio.aws.omics.model.ListReferenceImportJobsResponse.wrap(buildAwsValue())
}
object ListReferenceImportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReferenceImportJobsResponse =
      zio.aws.omics.model.ListReferenceImportJobsResponse(
        importJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def importJobs
        : Optional[List[zio.aws.omics.model.ImportReferenceJobItem.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getImportJobs: ZIO[Any, AwsError, List[
      zio.aws.omics.model.ImportReferenceJobItem.ReadOnly
    ]] = AwsError.unwrapOptionField("importJobs", importJobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse
  ) extends zio.aws.omics.model.ListReferenceImportJobsResponse.ReadOnly {
    override val importJobs
        : Optional[List[zio.aws.omics.model.ImportReferenceJobItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.ImportReferenceJobItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse
  ): zio.aws.omics.model.ListReferenceImportJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
