package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  NextToken,
  ListReferenceStoresRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReferenceStoresRequest(
    filter: Optional[zio.aws.omics.model.ReferenceStoreFilter] =
      Optional.Absent,
    maxResults: Optional[ListReferenceStoresRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest = {
    import ListReferenceStoresRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        maxResults.map(value =>
          ListReferenceStoresRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReferenceStoresRequest.ReadOnly =
    zio.aws.omics.model.ListReferenceStoresRequest.wrap(buildAwsValue())
}
object ListReferenceStoresRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReferenceStoresRequest =
      zio.aws.omics.model.ListReferenceStoresRequest(
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter: Optional[zio.aws.omics.model.ReferenceStoreFilter.ReadOnly]
    def maxResults: Optional[ListReferenceStoresRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.omics.model.ReferenceStoreFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults
        : ZIO[Any, AwsError, ListReferenceStoresRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest
  ) extends zio.aws.omics.model.ListReferenceStoresRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.omics.model.ReferenceStoreFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.omics.model.ReferenceStoreFilter.wrap(value))
    override val maxResults
        : Optional[ListReferenceStoresRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListReferenceStoresRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest
  ): zio.aws.omics.model.ListReferenceStoresRequest.ReadOnly = new Wrapper(impl)
}
