package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListReferenceStoresResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    referenceStores: Iterable[zio.aws.omics.model.ReferenceStoreDetail]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse = {
    import ListReferenceStoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .referenceStores(referenceStores.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReferenceStoresResponse.ReadOnly =
    zio.aws.omics.model.ListReferenceStoresResponse.wrap(buildAwsValue())
}
object ListReferenceStoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReferenceStoresResponse =
      zio.aws.omics.model.ListReferenceStoresResponse(
        nextToken.map(value => value),
        referenceStores.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def referenceStores: List[zio.aws.omics.model.ReferenceStoreDetail.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReferenceStores: ZIO[Any, Nothing, List[
      zio.aws.omics.model.ReferenceStoreDetail.ReadOnly
    ]] = ZIO.succeed(referenceStores)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse
  ) extends zio.aws.omics.model.ListReferenceStoresResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val referenceStores
        : List[zio.aws.omics.model.ReferenceStoreDetail.ReadOnly] = impl
      .referenceStores()
      .asScala
      .map { item =>
        zio.aws.omics.model.ReferenceStoreDetail.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse
  ): zio.aws.omics.model.ListReferenceStoresResponse.ReadOnly = new Wrapper(
    impl
  )
}
