package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ReferenceStoreId,
  NextToken,
  ListReferencesRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReferencesRequest(
    filter: Optional[zio.aws.omics.model.ReferenceFilter] = Optional.Absent,
    maxResults: Optional[ListReferencesRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    referenceStoreId: ReferenceStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReferencesRequest = {
    import ListReferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReferencesRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        maxResults.map(value =>
          ListReferencesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .referenceStoreId(
        ReferenceStoreId.unwrap(referenceStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReferencesRequest.ReadOnly =
    zio.aws.omics.model.ListReferencesRequest.wrap(buildAwsValue())
}
object ListReferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReferencesRequest =
      zio.aws.omics.model.ListReferencesRequest(
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        referenceStoreId
      )
    def filter: Optional[zio.aws.omics.model.ReferenceFilter.ReadOnly]
    def maxResults: Optional[ListReferencesRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def referenceStoreId: ReferenceStoreId
    def getFilter
        : ZIO[Any, AwsError, zio.aws.omics.model.ReferenceFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getMaxResults
        : ZIO[Any, AwsError, ListReferencesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReferenceStoreId: ZIO[Any, Nothing, ReferenceStoreId] =
      ZIO.succeed(referenceStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReferencesRequest
  ) extends zio.aws.omics.model.ListReferencesRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.omics.model.ReferenceFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.omics.model.ReferenceFilter.wrap(value))
    override val maxResults: Optional[ListReferencesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListReferencesRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val referenceStoreId: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.referenceStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReferencesRequest
  ): zio.aws.omics.model.ListReferencesRequest.ReadOnly = new Wrapper(impl)
}
