package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListReferencesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    references: Iterable[zio.aws.omics.model.ReferenceListItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReferencesResponse = {
    import ListReferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReferencesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .references(references.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReferencesResponse.ReadOnly =
    zio.aws.omics.model.ListReferencesResponse.wrap(buildAwsValue())
}
object ListReferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReferencesResponse =
      zio.aws.omics.model.ListReferencesResponse(
        nextToken.map(value => value),
        references.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def references: List[zio.aws.omics.model.ReferenceListItem.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReferences: ZIO[Any, Nothing, List[
      zio.aws.omics.model.ReferenceListItem.ReadOnly
    ]] = ZIO.succeed(references)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReferencesResponse
  ) extends zio.aws.omics.model.ListReferencesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val references
        : List[zio.aws.omics.model.ReferenceListItem.ReadOnly] = impl
      .references()
      .asScala
      .map { item =>
        zio.aws.omics.model.ReferenceListItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReferencesResponse
  ): zio.aws.omics.model.ListReferencesResponse.ReadOnly = new Wrapper(impl)
}
