package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  RunGroupListToken,
  RunGroupName,
  ListRunGroupsRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRunGroupsRequest(
    maxResults: Optional[ListRunGroupsRequestMaxResultsInteger] =
      Optional.Absent,
    name: Optional[RunGroupName] = Optional.Absent,
    startingToken: Optional[RunGroupListToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListRunGroupsRequest = {
    import ListRunGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListRunGroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListRunGroupsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        name.map(value => RunGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        startingToken.map(value =>
          RunGroupListToken.unwrap(value): java.lang.String
        )
      )(_.startingToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListRunGroupsRequest.ReadOnly =
    zio.aws.omics.model.ListRunGroupsRequest.wrap(buildAwsValue())
}
object ListRunGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListRunGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListRunGroupsRequest =
      zio.aws.omics.model.ListRunGroupsRequest(
        maxResults.map(value => value),
        name.map(value => value),
        startingToken.map(value => value)
      )
    def maxResults: Optional[ListRunGroupsRequestMaxResultsInteger]
    def name: Optional[RunGroupName]
    def startingToken: Optional[RunGroupListToken]
    def getMaxResults
        : ZIO[Any, AwsError, ListRunGroupsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getName: ZIO[Any, AwsError, RunGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getStartingToken: ZIO[Any, AwsError, RunGroupListToken] =
      AwsError.unwrapOptionField("startingToken", startingToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListRunGroupsRequest
  ) extends zio.aws.omics.model.ListRunGroupsRequest.ReadOnly {
    override val maxResults: Optional[ListRunGroupsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListRunGroupsRequestMaxResultsInteger(value)
        )
    override val name: Optional[RunGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.RunGroupName(value))
    override val startingToken: Optional[RunGroupListToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startingToken())
        .map(value => zio.aws.omics.model.primitives.RunGroupListToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListRunGroupsRequest
  ): zio.aws.omics.model.ListRunGroupsRequest.ReadOnly = new Wrapper(impl)
}
