package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  TaskListToken,
  ListRunTasksRequestMaxResultsInteger,
  RunId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRunTasksRequest(
    id: RunId,
    maxResults: Optional[ListRunTasksRequestMaxResultsInteger] =
      Optional.Absent,
    startingToken: Optional[TaskListToken] = Optional.Absent,
    status: Optional[zio.aws.omics.model.TaskStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListRunTasksRequest = {
    import ListRunTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListRunTasksRequest
      .builder()
      .id(RunId.unwrap(id): java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          ListRunTasksRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        startingToken.map(value =>
          TaskListToken.unwrap(value): java.lang.String
        )
      )(_.startingToken)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListRunTasksRequest.ReadOnly =
    zio.aws.omics.model.ListRunTasksRequest.wrap(buildAwsValue())
}
object ListRunTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListRunTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListRunTasksRequest =
      zio.aws.omics.model.ListRunTasksRequest(
        id,
        maxResults.map(value => value),
        startingToken.map(value => value),
        status.map(value => value)
      )
    def id: RunId
    def maxResults: Optional[ListRunTasksRequestMaxResultsInteger]
    def startingToken: Optional[TaskListToken]
    def status: Optional[zio.aws.omics.model.TaskStatus]
    def getId: ZIO[Any, Nothing, RunId] = ZIO.succeed(id)
    def getMaxResults
        : ZIO[Any, AwsError, ListRunTasksRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStartingToken: ZIO[Any, AwsError, TaskListToken] =
      AwsError.unwrapOptionField("startingToken", startingToken)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.TaskStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListRunTasksRequest
  ) extends zio.aws.omics.model.ListRunTasksRequest.ReadOnly {
    override val id: RunId = zio.aws.omics.model.primitives.RunId(impl.id())
    override val maxResults: Optional[ListRunTasksRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListRunTasksRequestMaxResultsInteger(value)
        )
    override val startingToken: Optional[TaskListToken] = zio.aws.core.internal
      .optionalFromNullable(impl.startingToken())
      .map(value => zio.aws.omics.model.primitives.TaskListToken(value))
    override val status: Optional[zio.aws.omics.model.TaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.TaskStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListRunTasksRequest
  ): zio.aws.omics.model.ListRunTasksRequest.ReadOnly = new Wrapper(impl)
}
