package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.RunListToken
import scala.jdk.CollectionConverters._
final case class ListRunsResponse(
    items: Optional[Iterable[zio.aws.omics.model.RunListItem]] =
      Optional.Absent,
    nextToken: Optional[RunListToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListRunsResponse = {
    import ListRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListRunsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => RunListToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListRunsResponse.ReadOnly =
    zio.aws.omics.model.ListRunsResponse.wrap(buildAwsValue())
}
object ListRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListRunsResponse =
      zio.aws.omics.model.ListRunsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.omics.model.RunListItem.ReadOnly]]
    def nextToken: Optional[RunListToken]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.omics.model.RunListItem.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, RunListToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListRunsResponse
  ) extends zio.aws.omics.model.ListRunsResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.omics.model.RunListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.RunListItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[RunListToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.RunListToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListRunsResponse
  ): zio.aws.omics.model.ListRunsResponse.ReadOnly = new Wrapper(impl)
}
