package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListSequenceStoresResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    sequenceStores: Iterable[zio.aws.omics.model.SequenceStoreDetail]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse = {
    import ListSequenceStoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .sequenceStores(sequenceStores.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListSequenceStoresResponse.ReadOnly =
    zio.aws.omics.model.ListSequenceStoresResponse.wrap(buildAwsValue())
}
object ListSequenceStoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListSequenceStoresResponse =
      zio.aws.omics.model.ListSequenceStoresResponse(
        nextToken.map(value => value),
        sequenceStores.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def sequenceStores: List[zio.aws.omics.model.SequenceStoreDetail.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSequenceStores: ZIO[Any, Nothing, List[
      zio.aws.omics.model.SequenceStoreDetail.ReadOnly
    ]] = ZIO.succeed(sequenceStores)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse
  ) extends zio.aws.omics.model.ListSequenceStoresResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val sequenceStores
        : List[zio.aws.omics.model.SequenceStoreDetail.ReadOnly] = impl
      .sequenceStores()
      .asScala
      .map { item =>
        zio.aws.omics.model.SequenceStoreDetail.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse
  ): zio.aws.omics.model.ListSequenceStoresResponse.ReadOnly = new Wrapper(impl)
}
