package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVariantImportJobsFilter(
    status: Optional[zio.aws.omics.model.JobStatus] = Optional.Absent,
    storeName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListVariantImportJobsFilter = {
    import ListVariantImportJobsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListVariantImportJobsFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(storeName.map(value => value: java.lang.String))(
        _.storeName
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListVariantImportJobsFilter.ReadOnly =
    zio.aws.omics.model.ListVariantImportJobsFilter.wrap(buildAwsValue())
}
object ListVariantImportJobsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListVariantImportJobsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListVariantImportJobsFilter =
      zio.aws.omics.model.ListVariantImportJobsFilter(
        status.map(value => value),
        storeName.map(value => value)
      )
    def status: Optional[zio.aws.omics.model.JobStatus]
    def storeName: Optional[String]
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStoreName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storeName", storeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListVariantImportJobsFilter
  ) extends zio.aws.omics.model.ListVariantImportJobsFilter.ReadOnly {
    override val status: Optional[zio.aws.omics.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.JobStatus.wrap(value))
    override val storeName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storeName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListVariantImportJobsFilter
  ): zio.aws.omics.model.ListVariantImportJobsFilter.ReadOnly = new Wrapper(
    impl
  )
}
