package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ListVariantImportJobsRequestNextTokenString,
  ListVariantImportJobsRequestMaxResultsInteger,
  ResourceIdentifier
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListVariantImportJobsRequest(
    filter: Optional[zio.aws.omics.model.ListVariantImportJobsFilter] =
      Optional.Absent,
    ids: Optional[Iterable[ResourceIdentifier]] = Optional.Absent,
    maxResults: Optional[ListVariantImportJobsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[ListVariantImportJobsRequestNextTokenString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest = {
    import ListVariantImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            ResourceIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(
        maxResults.map(value =>
          ListVariantImportJobsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          ListVariantImportJobsRequestNextTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListVariantImportJobsRequest.ReadOnly =
    zio.aws.omics.model.ListVariantImportJobsRequest.wrap(buildAwsValue())
}
object ListVariantImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListVariantImportJobsRequest =
      zio.aws.omics.model.ListVariantImportJobsRequest(
        filter.map(value => value.asEditable),
        ids.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter
        : Optional[zio.aws.omics.model.ListVariantImportJobsFilter.ReadOnly]
    def ids: Optional[List[ResourceIdentifier]]
    def maxResults: Optional[ListVariantImportJobsRequestMaxResultsInteger]
    def nextToken: Optional[ListVariantImportJobsRequestNextTokenString]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.omics.model.ListVariantImportJobsFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getIds: ZIO[Any, AwsError, List[ResourceIdentifier]] =
      AwsError.unwrapOptionField("ids", ids)
    def getMaxResults
        : ZIO[Any, AwsError, ListVariantImportJobsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken
        : ZIO[Any, AwsError, ListVariantImportJobsRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest
  ) extends zio.aws.omics.model.ListVariantImportJobsRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.omics.model.ListVariantImportJobsFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.omics.model.ListVariantImportJobsFilter.wrap(value)
        )
    override val ids: Optional[List[ResourceIdentifier]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.omics.model.primitives.ResourceIdentifier(item)
        }.toList
      )
    override val maxResults
        : Optional[ListVariantImportJobsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListVariantImportJobsRequestMaxResultsInteger(value)
        )
    override val nextToken
        : Optional[ListVariantImportJobsRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListVariantImportJobsRequestNextTokenString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest
  ): zio.aws.omics.model.ListVariantImportJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
