package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVariantStoresResponse(
    nextToken: Optional[String] = Optional.Absent,
    variantStores: Optional[Iterable[zio.aws.omics.model.VariantStoreItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListVariantStoresResponse = {
    import ListVariantStoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListVariantStoresResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        variantStores.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.variantStores)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListVariantStoresResponse.ReadOnly =
    zio.aws.omics.model.ListVariantStoresResponse.wrap(buildAwsValue())
}
object ListVariantStoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListVariantStoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListVariantStoresResponse =
      zio.aws.omics.model.ListVariantStoresResponse(
        nextToken.map(value => value),
        variantStores.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def variantStores
        : Optional[List[zio.aws.omics.model.VariantStoreItem.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVariantStores: ZIO[Any, AwsError, List[
      zio.aws.omics.model.VariantStoreItem.ReadOnly
    ]] = AwsError.unwrapOptionField("variantStores", variantStores)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListVariantStoresResponse
  ) extends zio.aws.omics.model.ListVariantStoresResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val variantStores
        : Optional[List[zio.aws.omics.model.VariantStoreItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.variantStores())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.VariantStoreItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListVariantStoresResponse
  ): zio.aws.omics.model.ListVariantStoresResponse.ReadOnly = new Wrapper(impl)
}
