package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  WorkflowListToken,
  WorkflowName,
  ListWorkflowsRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListWorkflowsRequest(
    maxResults: Optional[ListWorkflowsRequestMaxResultsInteger] =
      Optional.Absent,
    name: Optional[WorkflowName] = Optional.Absent,
    startingToken: Optional[WorkflowListToken] = Optional.Absent,
    `type`: Optional[zio.aws.omics.model.WorkflowType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListWorkflowsRequest = {
    import ListWorkflowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListWorkflowsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListWorkflowsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        name.map(value => WorkflowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        startingToken.map(value =>
          WorkflowListToken.unwrap(value): java.lang.String
        )
      )(_.startingToken)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListWorkflowsRequest.ReadOnly =
    zio.aws.omics.model.ListWorkflowsRequest.wrap(buildAwsValue())
}
object ListWorkflowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListWorkflowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListWorkflowsRequest =
      zio.aws.omics.model.ListWorkflowsRequest(
        maxResults.map(value => value),
        name.map(value => value),
        startingToken.map(value => value),
        `type`.map(value => value)
      )
    def maxResults: Optional[ListWorkflowsRequestMaxResultsInteger]
    def name: Optional[WorkflowName]
    def startingToken: Optional[WorkflowListToken]
    def `type`: Optional[zio.aws.omics.model.WorkflowType]
    def getMaxResults
        : ZIO[Any, AwsError, ListWorkflowsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getName: ZIO[Any, AwsError, WorkflowName] =
      AwsError.unwrapOptionField("name", name)
    def getStartingToken: ZIO[Any, AwsError, WorkflowListToken] =
      AwsError.unwrapOptionField("startingToken", startingToken)
    def getType: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListWorkflowsRequest
  ) extends zio.aws.omics.model.ListWorkflowsRequest.ReadOnly {
    override val maxResults: Optional[ListWorkflowsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListWorkflowsRequestMaxResultsInteger(value)
        )
    override val name: Optional[WorkflowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.WorkflowName(value))
    override val startingToken: Optional[WorkflowListToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startingToken())
        .map(value => zio.aws.omics.model.primitives.WorkflowListToken(value))
    override val `type`: Optional[zio.aws.omics.model.WorkflowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.omics.model.WorkflowType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListWorkflowsRequest
  ): zio.aws.omics.model.ListWorkflowsRequest.ReadOnly = new Wrapper(impl)
}
