package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.WorkflowListToken
import scala.jdk.CollectionConverters._
final case class ListWorkflowsResponse(
    items: Optional[Iterable[zio.aws.omics.model.WorkflowListItem]] =
      Optional.Absent,
    nextToken: Optional[WorkflowListToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListWorkflowsResponse = {
    import ListWorkflowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListWorkflowsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value =>
          WorkflowListToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListWorkflowsResponse.ReadOnly =
    zio.aws.omics.model.ListWorkflowsResponse.wrap(buildAwsValue())
}
object ListWorkflowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListWorkflowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListWorkflowsResponse =
      zio.aws.omics.model.ListWorkflowsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.omics.model.WorkflowListItem.ReadOnly]]
    def nextToken: Optional[WorkflowListToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.omics.model.WorkflowListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, WorkflowListToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListWorkflowsResponse
  ) extends zio.aws.omics.model.ListWorkflowsResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.omics.model.WorkflowListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.WorkflowListItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[WorkflowListToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.WorkflowListToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListWorkflowsResponse
  ): zio.aws.omics.model.ListWorkflowsResponse.ReadOnly = new Wrapper(impl)
}
