package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReadSetFiles(
    index: Optional[zio.aws.omics.model.FileInformation] = Optional.Absent,
    source1: Optional[zio.aws.omics.model.FileInformation] = Optional.Absent,
    source2: Optional[zio.aws.omics.model.FileInformation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ReadSetFiles = {
    import ReadSetFiles.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ReadSetFiles
      .builder()
      .optionallyWith(index.map(value => value.buildAwsValue()))(_.index)
      .optionallyWith(source1.map(value => value.buildAwsValue()))(_.source1)
      .optionallyWith(source2.map(value => value.buildAwsValue()))(_.source2)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ReadSetFiles.ReadOnly =
    zio.aws.omics.model.ReadSetFiles.wrap(buildAwsValue())
}
object ReadSetFiles {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ReadSetFiles
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ReadSetFiles =
      zio.aws.omics.model.ReadSetFiles(
        index.map(value => value.asEditable),
        source1.map(value => value.asEditable),
        source2.map(value => value.asEditable)
      )
    def index: Optional[zio.aws.omics.model.FileInformation.ReadOnly]
    def source1: Optional[zio.aws.omics.model.FileInformation.ReadOnly]
    def source2: Optional[zio.aws.omics.model.FileInformation.ReadOnly]
    def getIndex
        : ZIO[Any, AwsError, zio.aws.omics.model.FileInformation.ReadOnly] =
      AwsError.unwrapOptionField("index", index)
    def getSource1
        : ZIO[Any, AwsError, zio.aws.omics.model.FileInformation.ReadOnly] =
      AwsError.unwrapOptionField("source1", source1)
    def getSource2
        : ZIO[Any, AwsError, zio.aws.omics.model.FileInformation.ReadOnly] =
      AwsError.unwrapOptionField("source2", source2)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ReadSetFiles
  ) extends zio.aws.omics.model.ReadSetFiles.ReadOnly {
    override val index: Optional[zio.aws.omics.model.FileInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.index())
        .map(value => zio.aws.omics.model.FileInformation.wrap(value))
    override val source1
        : Optional[zio.aws.omics.model.FileInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source1())
        .map(value => zio.aws.omics.model.FileInformation.wrap(value))
    override val source2
        : Optional[zio.aws.omics.model.FileInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source2())
        .map(value => zio.aws.omics.model.FileInformation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ReadSetFiles
  ): zio.aws.omics.model.ReadSetFiles.ReadOnly = new Wrapper(impl)
}
